/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.methods.MethodFactory;
import com.liferay.portal.kernel.webdav.methods.MethodFactoryRegistryUtil;

public abstract class BaseWebDAVStorageImpl
implements WebDAVStorage {
    private String _rootPath;
    private String _token;

    @Override
    public int copyCollectionResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        return 403;
    }

    @Override
    public int copySimpleResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        return 403;
    }

    @Override
    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return 403;
    }

    @Override
    public MethodFactory getMethodFactory() {
        return MethodFactoryRegistryUtil.getDefaultMethodFactory();
    }

    @Override
    public String getRootPath() {
        return this._rootPath;
    }

    @Override
    public String getToken() {
        return this._token;
    }

    @Override
    public boolean isAvailable(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this.getResource(webDAVRequest) != null;
    }

    @Override
    public boolean isSupportsClassTwo() {
        return false;
    }

    @Override
    public Status lockResource(WebDAVRequest webDAVRequest, String owner, long timeout) throws WebDAVException {
        return null;
    }

    @Override
    public Status makeCollection(WebDAVRequest webDAVRequest) throws WebDAVException {
        return new Status(403);
    }

    @Override
    public int moveCollectionResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        return 403;
    }

    @Override
    public int moveSimpleResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        return 403;
    }

    @Override
    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return 403;
    }

    @Override
    public Lock refreshResourceLock(WebDAVRequest webDAVRequest, String uuid, long timeout) throws WebDAVException {
        return null;
    }

    @Override
    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }

    @Override
    public void setToken(String token) {
        this._token = token;
    }

    @Override
    public boolean unlockResource(WebDAVRequest webDAVRequest, String token) throws WebDAVException {
        return false;
    }

    protected long getPlid(long groupId) {
        return LayoutLocalServiceUtil.getDefaultPlid(groupId);
    }

    protected boolean isAddGroupPermissions(long groupId) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        return !group.isUser();
    }

    @Deprecated
    protected boolean isAddGuestPermissions(long groupId) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        return group.getType() == 1;
    }
}

