/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.model;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.social.kernel.model.SocialAchievement;
import com.liferay.social.kernel.model.SocialActivityCounterDefinition;
import com.liferay.social.kernel.model.SocialActivityProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SocialActivityDefinition
implements Serializable {
    private final List<SocialAchievement> _achievements = new ArrayList<SocialAchievement>();
    private final Map<String, SocialActivityCounterDefinition> _activityCounterDefinitions = new HashMap<String, SocialActivityCounterDefinition>();
    private SocialActivityProcessor _activityProcessor;
    private int _activityType;
    private boolean _countersEnabled = true;
    private String _languageKey;
    private boolean _logActivity;
    private String _modelName;

    public void addCounter(SocialActivityCounterDefinition activityCounterDefinition) {
        this._activityCounterDefinitions.put(activityCounterDefinition.getName(), activityCounterDefinition);
    }

    public SocialActivityDefinition clone() {
        SocialActivityDefinition activityDefinition = new SocialActivityDefinition();
        for (SocialActivityCounterDefinition activityCounterDefinition : this._activityCounterDefinitions.values()) {
            activityDefinition.addCounter(activityCounterDefinition.clone());
        }
        List<SocialAchievement> achievements = activityDefinition.getAchievements();
        achievements.addAll(this._achievements);
        activityDefinition.setActivityProcessor(this._activityProcessor);
        activityDefinition.setActivityType(this._activityType);
        activityDefinition.setCountersEnabled(this._countersEnabled);
        activityDefinition.setLanguageKey(this._languageKey);
        activityDefinition.setLogActivity(this._logActivity);
        activityDefinition.setModelName(this._modelName);
        return activityDefinition;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SocialActivityDefinition)) {
            return false;
        }
        SocialActivityDefinition activityDefinition = (SocialActivityDefinition)obj;
        return activityDefinition != null && Objects.equals(this._achievements, activityDefinition.getAchievements()) && Objects.equals(this._activityCounterDefinitions, activityDefinition._activityCounterDefinitions) && Objects.equals(this._activityProcessor, activityDefinition.getActivityProcessor()) && this._activityType == activityDefinition.getActivityType() && this._countersEnabled == activityDefinition.isCountersEnabled() && Objects.equals(this._languageKey, activityDefinition.getLanguageKey()) && this._logActivity == activityDefinition.isLogActivity() && Objects.equals(this._modelName, activityDefinition.getModelName());
    }

    public List<SocialAchievement> getAchievements() {
        return this._achievements;
    }

    public SocialActivityCounterDefinition getActivityCounterDefinition(String name) {
        return this._activityCounterDefinitions.get(name);
    }

    public Collection<SocialActivityCounterDefinition> getActivityCounterDefinitions() {
        return this._activityCounterDefinitions.values();
    }

    public SocialActivityProcessor getActivityProcessor() {
        return this._activityProcessor;
    }

    public int getActivityType() {
        return this._activityType;
    }

    public String getLanguageKey() {
        return this._languageKey;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getName(Locale locale) {
        return LanguageUtil.get(locale, StringBundler.concat("social.activity.", this._modelName, ".", this._languageKey));
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._achievements);
        hash = HashUtil.hash((int)hash, this._activityCounterDefinitions);
        hash = HashUtil.hash((int)hash, (Object)this._activityProcessor);
        hash = HashUtil.hash((int)hash, (int)this._activityType);
        hash = HashUtil.hash((int)hash, (boolean)this._countersEnabled);
        hash = HashUtil.hash((int)hash, (Object)this._languageKey);
        hash = HashUtil.hash((int)hash, (boolean)this._logActivity);
        return HashUtil.hash((int)hash, (Object)this._modelName);
    }

    public boolean isCountersEnabled() {
        return this._countersEnabled;
    }

    public boolean isLogActivity() {
        return this._logActivity;
    }

    public void setActivityProcessor(SocialActivityProcessor activityProcessor) {
        this._activityProcessor = activityProcessor;
    }

    public void setActivityType(int activityKey) {
        this._activityType = activityKey;
    }

    public void setCounters(List<SocialActivityCounterDefinition> activityCounterDefinitions) {
        this._activityCounterDefinitions.clear();
        for (SocialActivityCounterDefinition activityCounterDefinition : activityCounterDefinitions) {
            this._activityCounterDefinitions.put(activityCounterDefinition.getName(), activityCounterDefinition);
        }
    }

    public void setCountersEnabled(boolean enabled) {
        this._countersEnabled = enabled;
    }

    public void setLanguageKey(String languageKey) {
        this._languageKey = languageKey;
    }

    public void setLogActivity(boolean logActivity) {
        this._logActivity = logActivity;
    }

    public void setModelName(String modelName) {
        this._modelName = modelName;
    }
}

