/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jmx.model;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class MBean
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(MBean.class);
    private final String _domainName;
    private final boolean _loaded;
    private final MBeanInfo _mBeanInfo;
    private final String _mBeanName;
    private final ObjectName _objectName;
    private List<String> _path;

    public MBean(ObjectName objectName) {
        this._objectName = objectName;
        this._domainName = objectName.getDomain();
        this._mBeanName = objectName.getKeyPropertyListString();
        this._loaded = false;
        this._mBeanInfo = null;
    }

    public MBean(ObjectName objectName, MBeanInfo mBeanInfo) {
        this._objectName = objectName;
        this._mBeanInfo = mBeanInfo;
        this._domainName = objectName.getDomain();
        this._mBeanName = objectName.getKeyPropertyListString();
        this._loaded = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MBean)) {
            return false;
        }
        MBean mBean = (MBean)obj;
        return Objects.equals(this._domainName, mBean._domainName) && Objects.equals(this._mBeanName, mBean._mBeanName);
    }

    public String getDomainName() {
        return this._domainName;
    }

    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    public String getMBeanName() {
        return this._mBeanName;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public List<String> getPath() {
        if (this._path == null) {
            String[] parts = StringUtil.split(this._mBeanName);
            this._path = new ArrayList<String>(parts.length);
            for (String part : parts) {
                String[] kvp = StringUtil.split(part, '=');
                if (kvp.length != 2) {
                    _log.error("Invalid MBean name syntax " + this._mBeanName);
                    continue;
                }
                this._path.add(kvp[1]);
            }
        }
        return this._path;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._domainName);
        return HashUtil.hash((int)hashCode, (Object)this._mBeanName);
    }

    public boolean isLoaded() {
        return this._loaded;
    }
}

