/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ModelListenerRegistrationUtil {
    private static final ModelListenerRegistrationUtil _instance = new ModelListenerRegistrationUtil();
    private final ConcurrentMap<Class<?>, List<ModelListener<?>>> _modelListeners = new ConcurrentHashMap();
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final ServiceTracker<ModelListener<?>, ModelListener<?>> _serviceTracker;

    public static <T> ModelListener<T>[] getModelListeners(Class<T> clazz) {
        return _instance._getModelListeners(clazz);
    }

    public static void register(ModelListener<?> modelListener) {
        Class<?> clazz = modelListener.getClass();
        _instance._register(clazz.getName(), modelListener);
    }

    public static void unregister(ModelListener<?> modelListener) {
        Class<?> clazz = modelListener.getClass();
        _instance._unregister(clazz.getName());
    }

    private ModelListenerRegistrationUtil() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(objectClass=" + ModelListener.class.getName() + ")");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new ModelListenerTrackerCustomizer());
        this._serviceTracker.open();
    }

    private <T> ModelListener<T>[] _getModelListeners(Class<T> clazz) {
        List modelListeners = (List)this._modelListeners.get(clazz);
        if (modelListeners == null) {
            return new ModelListener[0];
        }
        return modelListeners.toArray(new ModelListener[0]);
    }

    private <T> void _register(String className, ModelListener<T> modelListener) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(ModelListener.class.getName(), modelListener);
        this._serviceRegistrations.put(className, serviceRegistration);
    }

    private void _unregister(String className) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(className);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class ModelListenerTrackerCustomizer
    implements ServiceTrackerCustomizer<ModelListener<?>, ModelListener<?>> {
        private ModelListenerTrackerCustomizer() {
        }

        public ModelListener<?> addingService(ServiceReference<ModelListener<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ModelListener modelListener = (ModelListener)registry.getService(serviceReference);
            Class<?> modelClass = this._getModelClass(modelListener);
            if (modelClass == null) {
                return null;
            }
            List<ModelListener<Object>> modelListeners = (ArrayList<ModelListener>)ModelListenerRegistrationUtil.this._modelListeners.get(modelClass);
            if (modelListeners == null) {
                modelListeners = new ArrayList<ModelListener>();
                List previousModelListeners = ModelListenerRegistrationUtil.this._modelListeners.putIfAbsent(modelClass, modelListeners);
                if (previousModelListeners != null) {
                    modelListeners = previousModelListeners;
                }
            }
            modelListeners.add(modelListener);
            return modelListener;
        }

        public void modifiedService(ServiceReference<ModelListener<?>> serviceReference, ModelListener<?> modelListener) {
        }

        public void removedService(ServiceReference<ModelListener<?>> serviceReference, ModelListener<?> modelListener) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            Class<?> modelClass = this._getModelClass(modelListener);
            List modelListeners = (List)ModelListenerRegistrationUtil.this._modelListeners.get(modelClass);
            if (modelListeners != null) {
                modelListeners.remove(modelListener);
                if (modelListeners.isEmpty()) {
                    ModelListenerRegistrationUtil.this._modelListeners.remove(modelClass);
                }
            }
        }

        private Class<?> _getGenericSuperType(Class<?> clazz) {
            try {
                ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
                Type[] types = parameterizedType.getActualTypeArguments();
                if (types.length > 0) {
                    return (Class)types[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        private Class<?> _getModelClass(ModelListener<?> modelListener) {
            InvocationHandler invocationHandler;
            Class<?> clazz = modelListener.getClass();
            if (ProxyUtil.isProxyClass(clazz) && (invocationHandler = ProxyUtil.getInvocationHandler(modelListener)) instanceof ClassLoaderBeanHandler) {
                ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                Object bean = classLoaderBeanHandler.getBean();
                clazz = bean.getClass();
            }
            return this._getGenericSuperType(clazz);
        }
    }
}

