/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.poller.PollerResponseClosedException;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultPollerResponse
implements PollerResponse {
    private String _chunkId;
    private volatile boolean _closed;
    private final Map<String, Object> _parameterMap = new ConcurrentHashMap<String, Object>();
    private PollerHeader _pollerHeader;
    private String _portletId;

    @Override
    public void close(Message message, PollerHeader pollerHeader, String portletId, String chunkId) {
        this._closed = true;
        this._pollerHeader = pollerHeader;
        this._portletId = portletId;
        this._chunkId = chunkId;
        String responseDestinationName = message.getResponseDestinationName();
        if (Validator.isNull(responseDestinationName)) {
            return;
        }
        Message responseMessage = MessageBusUtil.createResponseMessage(message);
        responseMessage.setPayload(this);
        MessageBusUtil.sendMessage(responseDestinationName, responseMessage);
    }

    @Override
    public PollerHeader getPollerHeader() {
        return this._pollerHeader;
    }

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public boolean isEmpty() {
        return this._parameterMap.isEmpty();
    }

    @Override
    public void setParameter(String name, JSONArray value) throws PollerResponseClosedException {
        if (this._closed) {
            throw new PollerResponseClosedException();
        }
        this._parameterMap.put(name, value);
    }

    @Override
    public void setParameter(String name, JSONObject value) throws PollerResponseClosedException {
        if (this._closed) {
            throw new PollerResponseClosedException();
        }
        this._parameterMap.put(name, value);
    }

    @Override
    public void setParameter(String name, String value) throws PollerResponseClosedException {
        if (this._closed) {
            throw new PollerResponseClosedException();
        }
        this._parameterMap.put(name, value);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject pollerResponseJSONObject = JSONUtil.put("portletId", (Object)this._portletId);
        if (Validator.isNotNull(this._chunkId)) {
            pollerResponseJSONObject.put("chunkId", this._chunkId);
        }
        JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject();
        for (Map.Entry<String, Object> entry : this._parameterMap.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                dataJSONObject.put(name, (JSONArray)value);
                continue;
            }
            if (value instanceof JSONObject) {
                dataJSONObject.put(name, (JSONObject)value);
                continue;
            }
            dataJSONObject.put(name, String.valueOf(value));
        }
        pollerResponseJSONObject.put("data", dataJSONObject);
        return pollerResponseJSONObject;
    }
}

