/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.registry.util.StringPlus;
import java.util.List;

public class PortletLayoutFinderRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletLayoutFinderRegistryUtil.class);
    private static final ServiceTrackerMap<String, List<PortletLayoutFinder>> _serviceTrackerMap = ServiceTrackerCollections.openMultiValueMap(PortletLayoutFinder.class, (String)"(model.class.name=*)", (serviceReference, emitter) -> {
        for (String modelClassName : StringPlus.asList((Object)serviceReference.getProperty("model.class.name"))) {
            emitter.emit((Object)modelClassName);
        }
    });

    public static PortletLayoutFinder getPortletLayoutFinder(String className) {
        List portletLayoutFinders = (List)_serviceTrackerMap.getService((Object)className);
        if (portletLayoutFinders == null) {
            return null;
        }
        return new CompositePortletLayoutFinder(portletLayoutFinders);
    }

    private static class CompositePortletLayoutFinder
    implements PortletLayoutFinder {
        private final Iterable<PortletLayoutFinder> _portletLayoutFinders;

        public CompositePortletLayoutFinder(Iterable<PortletLayoutFinder> portletLayoutFinders) {
            this._portletLayoutFinders = portletLayoutFinders;
        }

        @Override
        public PortletLayoutFinder.Result find(ThemeDisplay themeDisplay, long groupId) {
            block3: {
                try {
                    for (PortletLayoutFinder portletLayoutFinder : this._portletLayoutFinders) {
                        PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, groupId);
                        if (result == null) continue;
                        return result;
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug(pe, pe);
                }
            }
            return null;
        }
    }
}

