/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.layouts.admin.kernel.model.LayoutTypePortletConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseUpgradePortletId
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradePortletId.class);

    @Override
    protected void doUpgrade() throws Exception {
        this.upgradeInstanceablePortletIds();
        this.upgradeUninstanceablePortletIds();
    }

    protected String getNewTypeSettings(String typeSettings, String oldPropertyId, String newPropertyId) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        String value = typeSettingsProperties.remove(oldPropertyId);
        if (value != null) {
            typeSettingsProperties.setProperty(newPropertyId, value);
        }
        return typeSettingsProperties.toString();
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, boolean exactMatch) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String typeSettingId = (String)entry.getKey();
            if (!LayoutTypePortletConstants.hasPortletIds(typeSettingId)) continue;
            Object[] portletIds = StringUtil.split((String)entry.getValue());
            for (int j = 0; j < portletIds.length; ++j) {
                Object portletId = portletIds[j];
                if (exactMatch) {
                    if (!((String)portletId).equals(oldRootPortletId)) continue;
                    portletIds[j] = newRootPortletId;
                    continue;
                }
                String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
                if (!rootPortletId.equals(oldRootPortletId)) continue;
                long userId = PortletIdCodec.decodeUserId((String)portletId);
                String instanceId = PortletIdCodec.decodeInstanceId((String)portletId);
                portletIds[j] = PortletIdCodec.encode(newRootPortletId, userId, instanceId);
            }
            String portletIdsString = StringUtil.merge(portletIds);
            typeSettingsProperties.setProperty(typeSettingId, portletIdsString);
        }
        return typeSettingsProperties.toString();
    }

    @Deprecated
    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, List<String> columnIds, boolean exactMatch) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        return this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, exactMatch);
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[0][0];
    }

    protected String getTypeSettingsCriteria(String portletId) {
        StringBundler sb = new StringBundler(21);
        sb.append("typeSettings like '%=");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_USER_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_USER_%'");
        return sb.toString();
    }

    protected String[] getUninstanceablePortletIds() {
        return new String[0];
    }

    @Deprecated
    protected void updateGroup(long groupId, String typeSettings) throws Exception {
        block14: {
            String sql = "update Group_ set typeSettings = ? where groupId = " + groupId;
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(sqle, sqle);
            }
        }
    }

    protected void updateGroup(String oldRootPortletId, String newRootPortletId) throws Exception {
        String oldStagedPortletId = this._getStagedPortletId(oldRootPortletId);
        String sql1 = StringBundler.concat((String[])new String[]{"select groupId, typeSettings from Group_ where typeSettings like ", "'%", oldStagedPortletId, "%'"});
        String sql2 = "update Group_ set typeSettings = ? where groupId = ?";
        try (PreparedStatement ps1 = this.connection.prepareStatement(sql1);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, sql2);
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldStagedPortletId, this._getStagedPortletId(newRootPortletId));
                ps2.setString(1, newTypeSettings);
                ps2.setLong(2, groupId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updateInstanceablePortletPreferences(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set portletId = '", newRootPortletId, "' where portletId = '", oldRootPortletId, "'"}));
        if (!newRootPortletId.contains("_INSTANCE_")) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set portletId = replace(", "portletId, '", oldRootPortletId, "_INSTANCE_', '", newRootPortletId, "_INSTANCE_') where portletId like '", oldRootPortletId, "_INSTANCE_%'"}));
        }
        this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set portletId = replace(portletId, ", "'", oldRootPortletId, "_USER_', '", newRootPortletId, "_USER_') where portletId like '", oldRootPortletId, "_USER_%'"}));
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        block14: {
            try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(sqle, sqle);
            }
        }
    }

    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        block27: {
            try (PreparedStatement ps = this.connection.prepareStatement("select typeSettings from Layout where plid = " + plid);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String typeSettings = rs.getString("typeSettings");
                    String newTypeSettings = StringUtil.replace(typeSettings, oldPortletId, newPortletId);
                    this.updateLayout(plid, newTypeSettings);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block27;
                _log.warn(e, e);
            }
        }
    }

    protected void updateLayoutRevision(long layoutRevisionId, String typeSettings) throws Exception {
        block14: {
            String sql = "update LayoutRevision set typeSettings = ? where layoutRevisionId = " + layoutRevisionId;
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(sqle, sqle);
            }
        }
    }

    protected void updateLayoutRevisions(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql1 = "select layoutRevisionId, typeSettings from LayoutRevision where " + this.getTypeSettingsCriteria(oldRootPortletId);
        String sql2 = "update LayoutRevision set typeSettings = ? where layoutRevisionId = ?";
        try (PreparedStatement ps1 = this.connection.prepareStatement(sql1);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, sql2);
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long layoutRevisionId = rs.getLong("layoutRevisionId");
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, exactMatch);
                ps2.setString(1, newTypeSettings);
                ps2.setLong(2, layoutRevisionId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updateLayouts(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql1 = "select plid, typeSettings from Layout where " + this.getTypeSettingsCriteria(oldRootPortletId);
        String sql2 = "update Layout set typeSettings = ? where plid = ?";
        try (PreparedStatement ps1 = this.connection.prepareStatement(sql1);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, sql2);
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, exactMatch);
                ps2.setString(1, newTypeSettings);
                ps2.setLong(2, plid);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        block2: {
            try {
                this.updatePortletId(oldRootPortletId, newRootPortletId);
                this.updateResourceAction(oldRootPortletId, newRootPortletId);
                this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
                this.updateUserNotificationDelivery(oldRootPortletId, newRootPortletId);
                this.updateUserNotificationEvent(oldRootPortletId, newRootPortletId);
                this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn(e, e);
            }
        }
    }

    protected void updatePortletId(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update Portlet set portletId = '", newRootPortletId, "' where portletId = '", oldRootPortletId, "'"}));
    }

    protected void updateResourceAction(String oldName, String newName) throws Exception {
        ArrayList<String> actionIds = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement("select actionId from ResourceAction where name = '" + newName + "'");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                actionIds.add(rs.getString("actionId"));
            }
        }
        if (actionIds.isEmpty()) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourceAction set name = '", newName, "' where name = '", oldName, "'"}));
        } else {
            StringBundler sb = new StringBundler(5 + 3 * actionIds.size());
            sb.append("update ResourceAction set name = '");
            sb.append(newName);
            sb.append("' where name = '");
            sb.append(oldName);
            sb.append("' and actionId not in (");
            for (int i = 0; i < actionIds.size(); ++i) {
                sb.append("'");
                sb.append((String)actionIds.get(i));
                if (i == actionIds.size() - 1) {
                    sb.append("')");
                    continue;
                }
                sb.append("', ");
            }
            this.runSQL(sb.toString());
            this.runSQL("delete from ResourceAction where name = '" + oldName + "'");
        }
    }

    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKey = replace(primKey, ", "'_LAYOUT_", oldRootPortletId, "', '_LAYOUT_", newRootPortletId, "') where name = '", oldRootPortletId, "' and primKey like '%_LAYOUT_", oldRootPortletId, "'"}));
        if (!newRootPortletId.contains("_INSTANCE_")) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKey = replace(", "primKey, '_LAYOUT_", oldRootPortletId, "_INSTANCE_', ", "'_LAYOUT_", newRootPortletId, "_INSTANCE_') where name = ", "'", oldRootPortletId, "' and primKey like '%_LAYOUT_", oldRootPortletId, "_INSTANCE_%'"}));
        }
        if (updateName) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKey = '", newRootPortletId, "' where name = '", oldRootPortletId, "' and primKey = '", oldRootPortletId, "'"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set name = '", newRootPortletId, "' where name = '", oldRootPortletId, "'"}));
        }
    }

    protected void updateUserNotificationDelivery(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update UserNotificationDelivery set portletId = '", newPortletId, "' where portletId = '", oldPortletId, "'"}));
    }

    protected void updateUserNotificationEvent(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update UserNotificationEvent set type_ = '", newPortletId, "' where type_ = '", oldPortletId, "'"}));
    }

    protected void upgradeInstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[][] renamePortletIdsArray;
            for (String[] renamePortletIds : renamePortletIdsArray = this.getRenamePortletIdsArray()) {
                String oldRootPortletId = renamePortletIds[0];
                String newRootPortletId = renamePortletIds[1];
                this.updateGroup(oldRootPortletId, newRootPortletId);
                this.updatePortlet(oldRootPortletId, newRootPortletId);
                this.updateLayoutRevisions(oldRootPortletId, newRootPortletId, false);
                this.updateLayouts(oldRootPortletId, newRootPortletId, false);
            }
        }
    }

    protected void upgradeUninstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] uninstanceablePortletIds;
            for (String portletId : uninstanceablePortletIds = this.getUninstanceablePortletIds()) {
                if (PortletIdCodec.hasInstanceId(portletId)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn("Portlet " + portletId + " is already instanceable");
                    continue;
                }
                PortletIdCodec.validatePortletName(portletId);
                String newPortletInstanceKey = PortletIdCodec.encode(portletId);
                this.updateInstanceablePortletPreferences(portletId, newPortletInstanceKey);
                this.updateResourcePermission(portletId, newPortletInstanceKey, false);
                this.updateLayoutRevisions(portletId, newPortletInstanceKey, true);
                this.updateLayouts(portletId, newPortletInstanceKey, true);
            }
        }
    }

    private String _getStagedPortletId(String portletId) {
        String key = portletId;
        if (key.startsWith("staged-portlet_")) {
            return key;
        }
        return "staged-portlet_".concat(portletId);
    }
}

