/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ratings.kernel;

import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public enum RatingsType {
    LIKE("like"),
    STACKED_STARS("stacked-stars"),
    STARS("stars"),
    THUMBS("thumbs");

    private final String _value;

    public static boolean isValid(String value) {
        if (Validator.isNull(value)) {
            return false;
        }
        return value.equals(LIKE.getValue()) || value.equals((Object)STACKED_STARS) || value.equals(STARS.getValue()) || value.equals(THUMBS.getValue());
    }

    public static RatingsType parse(String value) {
        if (Objects.equals(LIKE.getValue(), value)) {
            return LIKE;
        }
        if (Objects.equals(STACKED_STARS.getValue(), value)) {
            return STACKED_STARS;
        }
        if (Objects.equals(STARS.getValue(), value)) {
            return STARS;
        }
        if (Objects.equals(THUMBS.getValue(), value)) {
            return THUMBS;
        }
        throw new IllegalArgumentException("Invalid value " + value);
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this._value;
    }

    private RatingsType(String value) {
        this._value = value;
    }
}

