/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ClusterNode
implements Serializable {
    private final InetAddress _bindInetAddress;
    private final String _clusterNodeId;
    private InetSocketAddress _portalInetSocketAddress;
    private String _portalProtocol;

    public ClusterNode(String clusterNodeId, InetAddress bindInetAddress) {
        if (clusterNodeId == null) {
            throw new IllegalArgumentException("Cluster node ID is null");
        }
        if (bindInetAddress == null) {
            throw new IllegalArgumentException("Bind inet address is null");
        }
        this._clusterNodeId = clusterNodeId;
        this._bindInetAddress = bindInetAddress;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClusterNode)) {
            return false;
        }
        ClusterNode clusterNode = (ClusterNode)object;
        return Objects.equals(this._clusterNodeId, clusterNode._clusterNodeId) && Objects.equals(this._bindInetAddress, clusterNode._bindInetAddress) && Objects.equals(this._portalInetSocketAddress, clusterNode._portalInetSocketAddress) && Objects.equals(this._portalProtocol, clusterNode._portalProtocol);
    }

    public InetAddress getBindInetAddress() {
        return this._bindInetAddress;
    }

    public String getClusterNodeId() {
        return this._clusterNodeId;
    }

    public InetAddress getPortalInetAddress() {
        if (this._portalInetSocketAddress == null) {
            return null;
        }
        return this._portalInetSocketAddress.getAddress();
    }

    public InetSocketAddress getPortalInetSocketAddress() {
        return this._portalInetSocketAddress;
    }

    public int getPortalPort() {
        if (this._portalInetSocketAddress == null) {
            return -1;
        }
        return this._portalInetSocketAddress.getPort();
    }

    public String getPortalProtocol() {
        return this._portalProtocol;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._clusterNodeId);
        hash = HashUtil.hash((int)hash, (Object)this._bindInetAddress);
        hash = HashUtil.hash((int)hash, (Object)this._portalInetSocketAddress);
        hash = HashUtil.hash((int)hash, (Object)this._portalProtocol);
        return hash;
    }

    public void setPortalInetSocketAddress(InetSocketAddress portalInetSocketAddress) {
        this._portalInetSocketAddress = portalInetSocketAddress;
    }

    public void setPortalProtocol(String portalProtocol) {
        this._portalProtocol = portalProtocol;
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{bindInetAddress=");
        sb.append((Object)this._bindInetAddress);
        sb.append(", clusterNodeId=");
        sb.append(this._clusterNodeId);
        sb.append(", portalInetSocketAddress=");
        sb.append((Object)this._portalInetSocketAddress);
        sb.append(", portalProtocol=");
        sb.append(this._portalProtocol);
        sb.append("}");
        return sb.toString();
    }
}

