/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Function;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class ContextResourcePathsUtil {
    public static <T> T visitResources(PortletContext portletContext, String path, String filePattern, Function<Enumeration<URL>, T> function) {
        return ContextResourcePathsUtil._visitResources(portletContext.getAttribute("osgi-bundlecontext"), path, filePattern, function);
    }

    public static <T> T visitResources(ServletContext servletContext, String path, String filePattern, Function<Enumeration<URL>, T> function) {
        return ContextResourcePathsUtil._visitResources(servletContext.getAttribute("osgi-bundlecontext"), path, filePattern, function);
    }

    private static <T> T _visitResources(Object bundleContext, String path, String filePattern, Function<Enumeration<URL>, T> function) {
        if (bundleContext == null) {
            return null;
        }
        Class<?> clazz = bundleContext.getClass();
        try {
            Method method = clazz.getMethod("getBundle", new Class[0]);
            Object bundle = method.invoke(bundleContext, new Object[0]);
            clazz = bundle.getClass();
            method = clazz.getMethod("findEntries", String.class, String.class, Boolean.TYPE);
            return function.apply((Enumeration)method.invoke(bundle, path, filePattern, true));
        }
        catch (ReflectiveOperationException roe) {
            return null;
        }
    }
}

