/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.kernel.io.AnnotatedObjectOutputStream;
import com.liferay.portal.kernel.io.BigEndianCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Serializer {
    protected static final int THREADLOCAL_BUFFER_COUNT_LIMIT;
    protected static final int THREADLOCAL_BUFFER_COUNT_MIN = 8;
    protected static final int THREADLOCAL_BUFFER_SIZE_LIMIT;
    protected static final int THREADLOCAL_BUFFER_SIZE_MIN = 16384;
    protected static final ThreadLocal<Reference<BufferQueue>> bufferQueueThreadLocal;
    protected byte[] buffer;
    protected int index;

    public Serializer() {
        BufferQueue bufferQueue = this._getBufferQueue();
        this.buffer = bufferQueue.dequeue();
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOf(this.buffer, this.index));
        if (this.buffer.length <= THREADLOCAL_BUFFER_SIZE_LIMIT) {
            BufferQueue bufferQueue = this._getBufferQueue();
            bufferQueue.enqueue(this.buffer);
        }
        this.buffer = null;
        return byteBuffer;
    }

    public void writeBoolean(boolean b) {
        BigEndianCodec.putBoolean(this.getBuffer(1), this.index++, b);
    }

    public void writeByte(byte b) {
        this.getBuffer((int)1)[this.index++] = b;
    }

    public void writeChar(char c) {
        BigEndianCodec.putChar(this.getBuffer(2), this.index, c);
        this.index += 2;
    }

    public void writeDouble(double d) {
        BigEndianCodec.putDouble(this.getBuffer(8), this.index, d);
        this.index += 8;
    }

    public void writeFloat(float f) {
        BigEndianCodec.putFloat(this.getBuffer(4), this.index, f);
        this.index += 4;
    }

    public void writeInt(int i) {
        BigEndianCodec.putInt(this.getBuffer(4), this.index, i);
        this.index += 4;
    }

    public void writeLong(long l) {
        BigEndianCodec.putLong(this.getBuffer(8), this.index, l);
        this.index += 8;
    }

    public void writeObject(Serializable serializable) {
        if (serializable == null) {
            this.writeByte((byte)8);
            return;
        }
        if (serializable instanceof Long) {
            this.writeByte((byte)7);
            this.writeLong((Long)serializable);
            return;
        }
        if (serializable instanceof String) {
            this.writeByte((byte)11);
            this.writeString((String)((Object)serializable));
            return;
        }
        if (serializable instanceof Integer) {
            this.writeByte((byte)6);
            this.writeInt((Integer)serializable);
            return;
        }
        if (serializable instanceof Boolean) {
            this.writeByte((byte)0);
            this.writeBoolean((Boolean)serializable);
            return;
        }
        if (serializable instanceof Class) {
            Class clazz = (Class)serializable;
            String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
            this.writeByte((byte)3);
            this.writeString(contextName);
            this.writeString(clazz.getName());
            return;
        }
        if (serializable instanceof Short) {
            this.writeByte((byte)10);
            this.writeShort((Short)serializable);
            return;
        }
        if (serializable instanceof Character) {
            this.writeByte((byte)2);
            this.writeChar(((Character)serializable).charValue());
            return;
        }
        if (serializable instanceof Byte) {
            this.writeByte((byte)1);
            this.writeByte((Byte)serializable);
            return;
        }
        if (serializable instanceof Double) {
            this.writeByte((byte)4);
            this.writeDouble((Double)serializable);
            return;
        }
        if (serializable instanceof Float) {
            this.writeByte((byte)5);
            this.writeFloat(((Float)serializable).floatValue());
            return;
        }
        this.writeByte((byte)9);
        try {
            AnnotatedObjectOutputStream objectOutputStream = new AnnotatedObjectOutputStream(new BufferOutputStream());
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write ordinary serializable object " + serializable, ioe);
        }
    }

    public void writeShort(short s) {
        BigEndianCodec.putShort(this.getBuffer(2), this.index, s);
        this.index += 2;
    }

    public void writeString(String s) {
        int i;
        int length = s.length();
        boolean asciiCode = true;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = s.charAt(i2);
            if (c != '\u0000' && c <= '\u007f') continue;
            asciiCode = false;
            break;
        }
        if (asciiCode) {
            byte[] buffer = this.getBuffer(length + 5);
            BigEndianCodec.putBoolean(buffer, this.index++, asciiCode);
            BigEndianCodec.putInt(buffer, this.index, length);
            this.index += 4;
            for (i = 0; i < length; ++i) {
                char c = s.charAt(i);
                buffer[this.index++] = (byte)c;
            }
        } else {
            byte[] buffer = this.getBuffer(length * 2 + 5);
            BigEndianCodec.putBoolean(buffer, this.index++, asciiCode);
            BigEndianCodec.putInt(buffer, this.index, length);
            this.index += 4;
            for (i = 0; i < length; ++i) {
                char c = s.charAt(i);
                BigEndianCodec.putChar(buffer, this.index, c);
                this.index += 2;
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.index);
        if (this.buffer.length <= THREADLOCAL_BUFFER_SIZE_LIMIT) {
            BufferQueue bufferQueue = this._getBufferQueue();
            bufferQueue.enqueue(this.buffer);
        }
        this.buffer = null;
    }

    protected final byte[] getBuffer(int ensureExtraSpace) {
        int minSize = this.index + ensureExtraSpace;
        if (minSize < 0) {
            throw new OutOfMemoryError();
        }
        int oldSize = this.buffer.length;
        if (minSize > oldSize) {
            int newSize = oldSize << 1;
            if (newSize < minSize) {
                newSize = minSize;
            }
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
        return this.buffer;
    }

    private BufferQueue _getBufferQueue() {
        Reference<BufferQueue> reference = bufferQueueThreadLocal.get();
        BufferQueue bufferQueue = null;
        if (reference != null) {
            bufferQueue = reference.get();
        }
        if (bufferQueue == null) {
            bufferQueue = new BufferQueue();
            bufferQueueThreadLocal.set(new SoftReference<BufferQueue>(bufferQueue));
        }
        return bufferQueue;
    }

    static {
        bufferQueueThreadLocal = new CentralizedThreadLocal(false);
        int threadLocalBufferCountLimit = Integer.getInteger(Serializer.class.getName() + ".thread.local.buffer.count.limit", 0);
        if (threadLocalBufferCountLimit < 8) {
            threadLocalBufferCountLimit = 8;
        }
        THREADLOCAL_BUFFER_COUNT_LIMIT = threadLocalBufferCountLimit;
        int threadLocalBufferSizeLimit = Integer.getInteger(Serializer.class.getName() + ".thread.local.buffer.size.limit", 0);
        if (threadLocalBufferSizeLimit < 16384) {
            threadLocalBufferSizeLimit = 16384;
        }
        THREADLOCAL_BUFFER_SIZE_LIMIT = threadLocalBufferSizeLimit;
    }

    protected class BufferOutputStream
    extends OutputStream {
        protected BufferOutputStream() {
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) {
            System.arraycopy(bytes, offset, Serializer.this.getBuffer(length), Serializer.this.index, length);
            Serializer.this.index += length;
        }

        @Override
        public void write(int b) {
            Serializer.this.getBuffer((int)1)[Serializer.this.index++] = (byte)b;
        }
    }

    protected static class BufferQueue {
        protected int count;
        protected BufferNode headBufferNode;

        protected BufferQueue() {
        }

        public byte[] dequeue() {
            if (this.headBufferNode == null) {
                return new byte[16384];
            }
            BufferNode bufferNode = this.headBufferNode;
            this.headBufferNode = this.headBufferNode.next;
            bufferNode.next = null;
            return bufferNode.buffer;
        }

        public void enqueue(byte[] buffer) {
            BufferNode bufferNode = new BufferNode(buffer);
            if (this.headBufferNode == null) {
                this.headBufferNode = bufferNode;
                this.count = 1;
                return;
            }
            BufferNode previousBufferNode = null;
            BufferNode currentBufferNode = this.headBufferNode;
            while (currentBufferNode != null && currentBufferNode.buffer.length > bufferNode.buffer.length) {
                previousBufferNode = currentBufferNode;
                currentBufferNode = currentBufferNode.next;
            }
            if (previousBufferNode == null) {
                bufferNode.next = this.headBufferNode;
                this.headBufferNode = bufferNode;
            } else {
                bufferNode.next = currentBufferNode;
                previousBufferNode.next = bufferNode;
            }
            if (++this.count > THREADLOCAL_BUFFER_COUNT_LIMIT) {
                if (previousBufferNode == null) {
                    previousBufferNode = this.headBufferNode;
                }
                currentBufferNode = previousBufferNode.next;
                while (currentBufferNode.next != null) {
                    previousBufferNode = currentBufferNode;
                    currentBufferNode = currentBufferNode.next;
                }
                previousBufferNode.next = null;
                currentBufferNode.buffer = null;
                currentBufferNode.next = null;
            }
        }
    }

    protected static class BufferNode {
        protected byte[] buffer;
        protected BufferNode next;

        public BufferNode(byte[] buffer) {
            this.buffer = buffer;
        }
    }
}

