/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.management;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.management.ManageAction;
import com.liferay.portal.kernel.management.ManageActionException;
import com.liferay.portal.kernel.management.PortalManagerUtil;
import com.liferay.portal.kernel.model.ClusterGroup;
import com.liferay.portal.kernel.util.MethodHandler;
import java.util.Iterator;
import java.util.List;

@Deprecated
public class ClusterManageActionWrapper
implements ManageAction<FutureClusterResponses> {
    private final ClusterGroup _clusterGroup;
    private final ManageAction<?> _manageAction;

    public ClusterManageActionWrapper(ClusterGroup clusterGroup, ManageAction<?> manageAction) {
        this._clusterGroup = clusterGroup;
        this._manageAction = manageAction;
    }

    @Override
    public FutureClusterResponses action() throws ManageActionException {
        try {
            return this.doAction();
        }
        catch (SystemException se) {
            throw new ManageActionException("Failed to execute cluster manage action", se);
        }
    }

    protected FutureClusterResponses doAction() throws ManageActionException {
        MethodHandler manageActionMethodHandler = PortalManagerUtil.createManageActionMethodHandler(this._manageAction);
        ClusterRequest clusterRequest = null;
        if (this._clusterGroup.isWholeCluster()) {
            clusterRequest = ClusterRequest.createMulticastRequest(manageActionMethodHandler);
        } else {
            this.verifyClusterGroup();
            clusterRequest = ClusterRequest.createUnicastRequest(manageActionMethodHandler, this._clusterGroup.getClusterNodeIdsArray());
        }
        return ClusterExecutorUtil.execute(clusterRequest);
    }

    protected void verifyClusterGroup() throws ManageActionException {
        String[] requiredClusterNodesIds;
        List<ClusterNode> clusterNodes = ClusterExecutorUtil.getClusterNodes();
        for (String requiredClusterNodeId : requiredClusterNodesIds = this._clusterGroup.getClusterNodeIdsArray()) {
            boolean verified = false;
            Iterator<ClusterNode> itr = clusterNodes.iterator();
            while (itr.hasNext()) {
                ClusterNode clusterNode = itr.next();
                String clusterNodeId = clusterNode.getClusterNodeId();
                if (!clusterNodeId.equals(requiredClusterNodeId)) continue;
                itr.remove();
                verified = true;
                break;
            }
            if (verified) continue;
            throw new ManageActionException("Cluster node " + requiredClusterNodeId + " is not available");
        }
    }
}

