/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.DestinationFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusEventListener;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import com.liferay.portal.kernel.messaging.config.MessagingConfiguratorRegistry;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistrar;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseMessagingConfigurator
implements MessagingConfigurator {
    private final Set<DestinationConfiguration> _destinationConfigurations = new HashSet<DestinationConfiguration>();
    private final Map<String, List<DestinationEventListener>> _destinationEventListeners = new HashMap<String, List<DestinationEventListener>>();
    private ServiceRegistrar<DestinationEventListener> _destinationEventListenerServiceRegistrar;
    private final List<Destination> _destinations = new ArrayList<Destination>();
    private ServiceRegistrar<Destination> _destinationServiceRegistrar;
    private volatile MessageBus _messageBus;
    private final List<MessageBusEventListener> _messageBusEventListeners = new ArrayList<MessageBusEventListener>();
    private ServiceRegistrar<MessageBusEventListener> _messageBusEventListenerServiceRegistrar;
    private final Map<String, List<MessageListener>> _messageListeners = new HashMap<String, List<MessageListener>>();
    private ServiceRegistrar<MessageListener> _messageListenerServiceRegistrar;
    private boolean _portalMessagingConfigurator;

    public void afterPropertiesSet() {
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){
            private ServiceReference<MessageBus> _serviceReference;

            public void dependenciesFulfilled() {
                Registry registry = RegistryUtil.getRegistry();
                this._serviceReference = registry.getServiceReference(MessageBus.class);
                BaseMessagingConfigurator.this._messageBus = (MessageBus)registry.getService(this._serviceReference);
                BaseMessagingConfigurator.this.initialize();
            }

            public void destroy() {
                if (this._serviceReference != null) {
                    Registry registry = RegistryUtil.getRegistry();
                    registry.ungetService(this._serviceReference);
                }
            }
        });
        serviceDependencyManager.registerDependencies(new Class[]{DestinationFactory.class, MessageBus.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        Registry registry = RegistryUtil.getRegistry();
        this._messageListenerServiceRegistrar = registry.getServiceRegistrar(MessageListener.class);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getOperatingClassloader());
            for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
                String destinationName = messageListeners.getKey();
                ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
                serviceDependencyManager.addServiceDependencyListener((ServiceDependencyListener)new DestinationServiceDependencyListener(destinationName, messageListeners.getValue()));
                Filter filter = registry.getFilter(StringBundler.concat((String[])new String[]{"(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"}));
                serviceDependencyManager.registerDependencies(new Filter[]{filter});
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void destroy() {
        if (this._messageListenerServiceRegistrar != null) {
            this._messageListenerServiceRegistrar.destroy();
        }
        if (this._destinationEventListenerServiceRegistrar != null) {
            this._destinationEventListenerServiceRegistrar.destroy();
        }
        if (this._destinationServiceRegistrar != null) {
            this._destinationServiceRegistrar.destroy();
        }
        if (this._messageBusEventListenerServiceRegistrar != null) {
            this._messageBusEventListenerServiceRegistrar.destroy();
        }
        this._destinationConfigurations.clear();
        this._destinationEventListeners.clear();
        this._messageListeners.clear();
        for (Destination destination : this._destinations) {
            destination.destroy();
        }
        this._destinations.clear();
        this._messageBusEventListeners.clear();
        String servletContextName = ServletContextClassLoaderPool.getServletContextName(this.getOperatingClassloader());
        if (servletContextName != null) {
            MessagingConfiguratorRegistry.unregisterMessagingConfigurator(servletContextName, this);
        }
    }

    @Override
    public void disconnect() {
        for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
            String destinationName = messageListeners.getKey();
            for (MessageListener messageListener : messageListeners.getValue()) {
                this._messageBus.unregisterMessageListener(destinationName, messageListener);
            }
        }
    }

    @Override
    public void setDestinationConfigurations(Set<DestinationConfiguration> destinationConfigurations) {
        this._destinationConfigurations.addAll(destinationConfigurations);
    }

    @Override
    public void setDestinationEventListeners(Map<String, List<DestinationEventListener>> destinationEventListeners) {
        this._destinationEventListeners.putAll(destinationEventListeners);
    }

    @Override
    public void setDestinations(List<Destination> destinations) {
        this._destinations.addAll(destinations);
    }

    @Override
    public void setMessageBusEventListeners(List<MessageBusEventListener> messageBusEventListeners) {
        this._messageBusEventListeners.addAll(messageBusEventListeners);
    }

    @Override
    public void setMessageListeners(Map<String, List<MessageListener>> messageListeners) {
        for (List<MessageListener> messageListenersList : messageListeners.values()) {
            for (MessageListener messageListener : messageListenersList) {
                Method setMessageBusMethod2;
                Class<?> messageListenerClass = messageListener.getClass();
                try {
                    setMessageBusMethod2 = messageListenerClass.getMethod("setMessageBus", MessageBus.class);
                    setMessageBusMethod2.setAccessible(true);
                    setMessageBusMethod2.invoke((Object)messageListener, this._messageBus);
                }
                catch (Exception setMessageBusMethod2) {
                    try {
                        setMessageBusMethod2 = messageListenerClass.getDeclaredMethod("setMessageBus", MessageBus.class);
                        setMessageBusMethod2.setAccessible(true);
                        setMessageBusMethod2.invoke((Object)messageListener, this._messageBus);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this._messageListeners.putAll(messageListeners);
    }

    protected abstract ClassLoader getOperatingClassloader();

    protected void initialize() {
        ClassLoader operatingClassLoader;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextClassLoader == (operatingClassLoader = this.getOperatingClassloader())) {
            this._portalMessagingConfigurator = true;
        }
        this.registerMessageBusEventListeners();
        this.registerDestinations();
        this.registerDestinationEventListeners();
        this.connect();
        String servletContextName = ServletContextClassLoaderPool.getServletContextName(operatingClassLoader);
        if (servletContextName != null) {
            MessagingConfiguratorRegistry.registerMessagingConfigurator(servletContextName, this);
        }
    }

    protected void registerDestinationEventListeners() {
        if (this._destinationEventListeners.isEmpty()) {
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        this._destinationEventListenerServiceRegistrar = registry.getServiceRegistrar(DestinationEventListener.class);
        for (final Map.Entry<String, List<DestinationEventListener>> entry : this._destinationEventListeners.entrySet()) {
            final String destinationName = entry.getKey();
            ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
            serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

                public void dependenciesFulfilled() {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("destination.name", destinationName);
                    for (DestinationEventListener destinationEventListener : (List)entry.getValue()) {
                        BaseMessagingConfigurator.this._destinationEventListenerServiceRegistrar.registerService(DestinationEventListener.class, (Object)destinationEventListener, properties);
                    }
                }

                public void destroy() {
                }
            });
            Filter filter = registry.getFilter(StringBundler.concat((String[])new String[]{"(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"}));
            serviceDependencyManager.registerDependencies(new Filter[]{filter});
        }
    }

    protected void registerDestinations() {
        for (DestinationConfiguration destinationConfiguration : this._destinationConfigurations) {
            this._destinations.add(DestinationFactoryUtil.createDestination(destinationConfiguration));
        }
        if (this._destinations.isEmpty()) {
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        this._destinationServiceRegistrar = registry.getServiceRegistrar(Destination.class);
        for (Destination destination : this._destinations) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("destination.name", destination.getName());
            this._destinationServiceRegistrar.registerService(Destination.class, (Object)destination, properties);
        }
    }

    protected void registerMessageBusEventListeners() {
        if (this._messageBusEventListeners.isEmpty()) {
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        this._messageBusEventListenerServiceRegistrar = registry.getServiceRegistrar(MessageBusEventListener.class);
        for (MessageBusEventListener messageBusEventListener : this._messageBusEventListeners) {
            this._messageBusEventListenerServiceRegistrar.registerService(MessageBusEventListener.class, (Object)messageBusEventListener);
        }
    }

    private class DestinationServiceDependencyListener
    implements ServiceDependencyListener {
        private final String _destinationName;
        private final List<MessageListener> _messageListeners;

        public DestinationServiceDependencyListener(String destinationName, List<MessageListener> messageListeners) {
            this._destinationName = destinationName;
            this._messageListeners = messageListeners;
        }

        public void dependenciesFulfilled() {
            ClassLoader operatingClassLoader = BaseMessagingConfigurator.this.getOperatingClassloader();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("destination.name", this._destinationName);
            properties.put("message.listener.operating.class.loader", operatingClassLoader);
            for (MessageListener messageListener : this._messageListeners) {
                BaseMessagingConfigurator.this._messageListenerServiceRegistrar.registerService(MessageListener.class, (Object)messageListener, properties);
            }
        }

        public void destroy() {
        }
    }
}

