/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import java.util.List;

public abstract class BaseControlPanelEntry
implements ControlPanelEntry {
    @Override
    public boolean hasAccessPermission(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        if (this.hasAccessPermissionDenied(permissionChecker, group, portlet)) {
            return false;
        }
        if (this.hasAccessPermissionExplicitlyGranted(permissionChecker, group, portlet)) {
            return true;
        }
        return this.hasPermissionImplicitlyGranted(permissionChecker, group, portlet);
    }

    protected long getDefaultPlid(Group group, String category) {
        long plid = 0L;
        if (category.startsWith("site_administration.") && (plid = group.getDefaultPublicPlid()) == 0L) {
            plid = group.getDefaultPrivatePlid();
        }
        return plid;
    }

    protected boolean hasAccessPermissionDenied(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        String category = portlet.getControlPanelEntryCategory();
        if (category.startsWith("site_administration.") && group.isLayoutPrototype()) {
            return true;
        }
        return category.equals("site_administration.content") && group.isLayout() && !portlet.isScopeable();
    }

    protected boolean hasAccessPermissionExplicitlyGranted(PermissionChecker permissionChecker, Group group, Portlet portlet) throws PortalException {
        List<String> resourceActions;
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        String category = portlet.getControlPanelEntryCategory();
        if (category == null) {
            category = "";
        }
        if (category.startsWith("site_administration.") && permissionChecker.isGroupAdmin(group.getGroupId()) && !group.isUser()) {
            return true;
        }
        long groupId = group.getGroupId();
        if (category.equals("control_panel.apps") || category.equals("control_panel.configuration") || category.equals("control_panel.sites") || category.equals("control_panel.system") || category.equals("control_panel.users") || category.equals("control_panel.workflow")) {
            groupId = 0L;
        }
        return (resourceActions = ResourceActionsUtil.getResourceActions(portlet.getPortletId())).contains("ACCESS_IN_CONTROL_PANEL") && PortletPermissionUtil.contains(permissionChecker, groupId, 0L, portlet.getRootPortletId(), "ACCESS_IN_CONTROL_PANEL", true);
    }

    protected boolean hasPermissionImplicitlyGranted(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        return false;
    }
}

