/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.WindowState;

public class WindowStateFactory {
    private static final Map<String, WindowState> _windowStates = new HashMap<String, WindowState>(){
        {
            try {
                for (Field field : LiferayWindowState.class.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != WindowState.class) continue;
                    WindowState windowState = (WindowState)field.get(null);
                    this.put(windowState.toString(), windowState);
                }
            }
            catch (IllegalAccessException iae) {
                throw new ExceptionInInitializerError(iae);
            }
        }
    };

    public static WindowState getWindowState(String name) {
        return WindowStateFactory.getWindowState(name, 2);
    }

    public static WindowState getWindowState(String name, int portletMajorVersion) {
        if (Validator.isNull(name)) {
            if (portletMajorVersion < 3) {
                return WindowState.NORMAL;
            }
            return WindowState.UNDEFINED;
        }
        WindowState windowState = _windowStates.get(name);
        if (windowState == null) {
            windowState = new WindowState(name);
        }
        return windowState;
    }
}

