/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.internal.util.ContextResourcePathsUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.bridges.mvc.FormMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommandCache;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderConstants;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class MVCPortlet
extends LiferayPortlet {
    protected String aboutTemplate;
    protected boolean clearRequestParameters;
    protected String configTemplate;
    protected boolean copyRequestParameters;
    protected String editDefaultsTemplate;
    protected String editGuestTemplate;
    protected String editTemplate;
    protected String helpTemplate;
    protected String previewTemplate;
    protected String printTemplate;
    protected String templatePath;
    protected String viewTemplate;
    private static final String _PATH_META_INF_RESOURCES = "/META-INF/resources";
    private static final Log _log = LogFactoryUtil.getLog(MVCPortlet.class);
    private static final Map<String, Map<String, Set<String>>> _validPathsMaps = new ConcurrentHashMap<String, Map<String, Set<String>>>();
    private MVCCommandCache<MVCActionCommand> _actionMVCCommandCache;
    private MVCCommandCache<MVCRenderCommand> _renderMVCCommandCache;
    private MVCCommandCache<MVCResourceCommand> _resourceMVCCommandCache;
    private Set<String> _validPaths;

    public void destroy() {
        PortletContext portletContext = this.getPortletContext();
        _validPathsMaps.remove(portletContext.getPortletContextName());
        super.destroy();
        this._actionMVCCommandCache.close();
        this._renderMVCCommandCache.close();
        this._resourceMVCCommandCache.close();
    }

    @Override
    public void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.aboutTemplate, renderRequest, renderResponse);
    }

    @Override
    public void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.configTemplate, renderRequest, renderResponse);
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editTemplate, renderRequest, renderResponse);
        }
    }

    @Override
    public void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editDefaultsTemplate, renderRequest, renderResponse);
        }
    }

    @Override
    public void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editGuestTemplate, renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.helpTemplate, renderRequest, renderResponse);
    }

    @Override
    public void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.previewTemplate, renderRequest, renderResponse);
    }

    @Override
    public void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.printTemplate, renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.viewTemplate, renderRequest, renderResponse);
    }

    @Override
    public void init() throws PortletException {
        super.init();
        this.templatePath = this._getInitParameter("template-path");
        if (Validator.isNull(this.templatePath)) {
            this.templatePath = "/";
        } else {
            if (this.templatePath.contains("\\") || this.templatePath.contains("//") || this.templatePath.contains(".") || this.templatePath.contains(" ")) {
                throw new PortletException("template-path " + this.templatePath + " has invalid characters");
            }
            if (!this.templatePath.startsWith("/") || !this.templatePath.endsWith("/")) {
                throw new PortletException("template-path " + this.templatePath + " must start and end with a /");
            }
        }
        this.aboutTemplate = this._getInitParameter("about-template");
        this.configTemplate = this._getInitParameter("config-template");
        this.editTemplate = this._getInitParameter("edit-template");
        this.editDefaultsTemplate = this._getInitParameter("edit-defaults-template");
        this.editGuestTemplate = this._getInitParameter("edit-guest-template");
        this.helpTemplate = this._getInitParameter("help-template");
        this.previewTemplate = this._getInitParameter("preview-template");
        this.printTemplate = this._getInitParameter("print-template");
        this.viewTemplate = this._getInitParameter("view-template");
        this.clearRequestParameters = GetterUtil.getBoolean(this.getInitParameter("clear-request-parameters"));
        this.copyRequestParameters = GetterUtil.getBoolean(this.getInitParameter("copy-request-parameters"), true);
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)this.getPortletConfig();
        String portletId = liferayPortletConfig.getPortletId();
        this._actionMVCCommandCache = new MVCCommandCache<MVCActionCommand>(MVCActionCommand.EMPTY, this.getInitParameter("mvc-action-command-package-prefix"), this.getPortletName(), portletId, MVCActionCommand.class, "ActionCommand");
        this._renderMVCCommandCache = new MVCCommandCache<MVCRenderCommand>(MVCRenderCommand.EMPTY, this.getInitParameter("mvc-render-command-package-prefix"), this.getPortletName(), portletId, MVCRenderCommand.class, "RenderCommand");
        this._resourceMVCCommandCache = new MVCCommandCache<MVCResourceCommand>(MVCResourceCommand.EMPTY, this.getInitParameter("mvc-resource-command-package-prefix"), this.getPortletName(), portletId, MVCResourceCommand.class, "ResourceCommand");
        this._initValidPaths(this.templatePath);
    }

    @Deprecated
    public void invokeTaglibDiscussionPagination(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        PortalUtil.invokeTaglibDiscussionPagination(this.getPortletConfig(), resourceRequest, resourceResponse);
    }

    @Override
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        super.processAction(actionRequest, actionResponse);
        if (this.copyRequestParameters) {
            PortalUtil.copyRequestParameters(actionRequest, actionResponse);
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.invokeHideDefaultSuccessMessage((PortletRequest)renderRequest);
        String mvcRenderCommandName = ParamUtil.getString((PortletRequest)renderRequest, "mvcRenderCommandName", "/");
        String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, "mvcPath");
        if (!mvcRenderCommandName.equals("/") || Validator.isNull(mvcPath)) {
            MVCRenderCommand mvcRenderCommand = this._renderMVCCommandCache.getMVCCommand(mvcRenderCommandName);
            mvcPath = null;
            if (mvcRenderCommand != MVCRenderCommand.EMPTY) {
                mvcPath = mvcRenderCommand.render(renderRequest, renderResponse);
            }
            if (MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH.equals(mvcPath)) {
                return;
            }
            if (Validator.isNotNull(mvcPath)) {
                renderRequest.setAttribute(this.getMVCPathAttributeName(renderResponse.getNamespace()), (Object)mvcPath);
            } else if (!mvcRenderCommandName.equals("/") && _log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(5);
                sb.append("No render mappings found for MVC render ");
                sb.append("command name \"");
                sb.append(HtmlUtil.escape(mvcRenderCommandName));
                sb.append("\" for portlet ");
                sb.append(renderRequest.getAttribute("PORTLET_ID"));
                _log.warn(sb.toString());
            }
        }
        super.render(renderRequest, renderResponse);
    }

    @Override
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        boolean invokeTaglibDiscussion;
        this.invokeHideDefaultSuccessMessage((PortletRequest)resourceRequest);
        String path = this.getPath((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (path != null) {
            this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
        }
        if (invokeTaglibDiscussion = GetterUtil.getBoolean(resourceRequest.getParameter("invokeTaglibDiscussion"))) {
            this.invokeTaglibDiscussionPagination(resourceRequest, resourceResponse);
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    @Override
    protected boolean callActionMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        Object[] actionNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, "javax.portlet.action");
        String actionName = StringUtil.merge(actionNames);
        if (!actionName.contains(",")) {
            MVCActionCommand mvcActionCommand = this._actionMVCCommandCache.getMVCCommand(actionName);
            if (mvcActionCommand != MVCActionCommand.EMPTY) {
                FormMVCActionCommand formMVCActionCommand;
                if (mvcActionCommand instanceof FormMVCActionCommand && !(formMVCActionCommand = (FormMVCActionCommand)mvcActionCommand).validateForm(actionRequest, actionResponse)) {
                    return false;
                }
                return mvcActionCommand.processAction(actionRequest, actionResponse);
            }
        } else {
            List<MVCActionCommand> mvcActionCommands = this._actionMVCCommandCache.getMVCCommands(actionName);
            if (!mvcActionCommands.isEmpty()) {
                boolean valid = true;
                for (MVCActionCommand mvcActionCommand : mvcActionCommands) {
                    if (!(mvcActionCommand instanceof FormMVCActionCommand)) continue;
                    FormMVCActionCommand formMVCActionCommand = (FormMVCActionCommand)mvcActionCommand;
                    valid &= formMVCActionCommand.validateForm(actionRequest, actionResponse);
                }
                if (!valid) {
                    return false;
                }
                for (MVCActionCommand mvcActionCommand : mvcActionCommands) {
                    if (mvcActionCommand.processAction(actionRequest, actionResponse)) continue;
                    return false;
                }
                return true;
            }
        }
        return super.callActionMethod(actionRequest, actionResponse);
    }

    @Override
    protected boolean callResourceMethod(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            this.checkPermissions((PortletRequest)resourceRequest);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        String resourceID = GetterUtil.getString(resourceRequest.getResourceID());
        if (!resourceID.contains(",")) {
            MVCResourceCommand mvcResourceCommand = this._resourceMVCCommandCache.getMVCCommand(resourceID);
            if (mvcResourceCommand != MVCResourceCommand.EMPTY) {
                return mvcResourceCommand.serveResource(resourceRequest, resourceResponse);
            }
        } else {
            List<MVCResourceCommand> mvcResourceCommands = this._resourceMVCCommandCache.getMVCCommands(resourceID);
            if (!mvcResourceCommands.isEmpty()) {
                for (MVCResourceCommand mvcResourceCommand : mvcResourceCommands) {
                    if (mvcResourceCommand.serveResource(resourceRequest, resourceResponse)) continue;
                    return false;
                }
                return true;
            }
        }
        return super.callResourceMethod(resourceRequest, resourceResponse);
    }

    protected void checkPermissions(PortletRequest portletRequest) throws Exception {
    }

    @Override
    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (path != null) {
            WindowState windowState = renderRequest.getWindowState();
            if (windowState.equals((Object)WindowState.MINIMIZED)) {
                return;
            }
            this.include(path, renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected MVCCommandCache<MVCActionCommand> getActionMVCCommandCache() {
        return this._actionMVCCommandCache;
    }

    protected String getMVCPathAttributeName(String namespace) {
        return namespace.concat(".").concat(MVCRenderConstants.MVC_PATH_REQUEST_ATTRIBUTE_NAME);
    }

    protected String getPath(PortletRequest portletRequest, PortletResponse portletResponse) {
        String mvcPath = portletRequest.getParameter("mvcPath");
        if (mvcPath == null) {
            mvcPath = (String)portletRequest.getAttribute(this.getMVCPathAttributeName(portletResponse.getNamespace()));
        }
        if (mvcPath == null) {
            mvcPath = portletRequest.getParameter("jspPage");
        }
        return mvcPath;
    }

    protected MVCCommandCache<MVCRenderCommand> getRenderMVCCommandCache() {
        return this._renderMVCCommandCache;
    }

    protected MVCCommandCache<MVCResourceCommand> getResourceMVCCommandCache() {
        return this._resourceMVCCommandCache;
    }

    protected void hideDefaultErrorMessage(PortletRequest portletRequest) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".hideDefaultErrorMessage");
    }

    protected void hideDefaultSuccessMessage(PortletRequest portletRequest) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".hideDefaultSuccessMessage");
    }

    protected void include(String path, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse, "ACTION_PHASE");
    }

    protected void include(String path, EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)eventRequest, (PortletResponse)eventResponse, "EVENT_PHASE");
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        PortletRequestDispatcher portletRequestDispatcher;
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        PortletContext portletContext = (PortletContext)httpServletRequest.getAttribute("portlet.context.override." + path);
        if (portletContext == null) {
            portletContext = this.getPortletContext();
        }
        if ((portletRequestDispatcher = portletContext.getRequestDispatcher(path)) == null) {
            _log.error(path + " is not a valid include");
        } else {
            if (Validator.isNotNull(path) && !this._validPaths.contains(path) && !this._validPaths.contains(_PATH_META_INF_RESOURCES.concat(path))) {
                throw new PortletException(StringBundler.concat((String[])new String[]{"Path ", path, " is not accessible by portlet ", this.getPortletName()}));
            }
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", Boolean.TRUE.toString());
        }
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse, "RENDER_PHASE");
    }

    protected void include(String path, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
    }

    protected void invokeHideDefaultSuccessMessage(PortletRequest portletRequest) {
        boolean hideDefaultSuccessMessage = ParamUtil.getBoolean(portletRequest, "hideDefaultSuccessMessage");
        if (hideDefaultSuccessMessage) {
            this.hideDefaultSuccessMessage(portletRequest);
        }
    }

    private String _getInitParameter(String name) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        if (name.equals("template-path")) {
            return this.getInitParameter("jsp-path");
        }
        if (name.endsWith("-template")) {
            name = name.substring(0, name.length() - 9) + "-jsp";
            return this.getInitParameter(name);
        }
        return null;
    }

    private Set<String> _getJspPaths(String path) {
        PortletContext portletContext = this.getPortletContext();
        Set pathsSet = ContextResourcePathsUtil.visitResources(portletContext, path, "*.jsp", enumeration -> {
            HashSet<String> paths = new HashSet<String>();
            if (enumeration == null) {
                return paths;
            }
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                paths.add(url.getPath());
            }
            return paths;
        });
        if (pathsSet != null) {
            return pathsSet;
        }
        HashSet<String> paths = new HashSet<String>();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(path);
        while ((path = (String)queue.poll()) != null) {
            Set childPaths = portletContext.getResourcePaths(path);
            if (childPaths == null) continue;
            for (String childPath : childPaths) {
                if (childPath.charAt(childPath.length() - 1) == '/') {
                    queue.add(childPath);
                    continue;
                }
                if (!childPath.endsWith(".jsp")) continue;
                paths.add(childPath);
            }
        }
        return paths;
    }

    private void _initValidPaths(String rootPath) {
        PortletApp portletApp;
        PortletContext portletContext = this.getPortletContext();
        String portletContextName = portletContext.getPortletContextName();
        Map validPathsMap = _validPathsMaps.get(portletContextName);
        if (validPathsMap != null) {
            this._validPaths = validPathsMap.get(rootPath);
            if (this._validPaths != null) {
                return;
            }
        } else {
            validPathsMap = _validPathsMaps.computeIfAbsent(portletContextName, key -> new ConcurrentHashMap());
        }
        if (rootPath.equals("/") && !(portletApp = PortletLocalServiceUtil.getPortletApp(portletContextName)).isWARFile()) {
            _log.error(StringBundler.concat((String[])new String[]{"Disabling paths for portlet ", this.getPortletName(), " because root path is configured to have access to ", "all portal paths"}));
            this._validPaths = validPathsMap.computeIfAbsent(rootPath, key -> Collections.emptySet());
            return;
        }
        this._validPaths = validPathsMap.computeIfAbsent(rootPath, key -> {
            Set<String> validPaths = this._getJspPaths((String)key);
            if (!(key.equals("/") || key.equals("/META-INF/") || key.equals("/META-INF/resources/"))) {
                validPaths.addAll(this._getJspPaths(_PATH_META_INF_RESOURCES.concat((String)key)));
            }
            Collections.addAll(validPaths, StringUtil.split(this.getInitParameter("valid-paths")));
            return validPaths;
        });
    }
}

