/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.configuration.icon;

import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIconServiceReferenceMapper;
import com.liferay.portal.kernel.portlet.configuration.icon.locator.PortletConfigurationIconLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;

public class PortletConfigurationIconTracker {
    private static final Set<String> _defaultPaths = Collections.singleton("-");
    private static final ServiceTrackerList<PortletConfigurationIconLocator> _serviceTrackerList = ServiceTrackerCollections.openList(PortletConfigurationIconLocator.class);
    private static final ServiceTrackerMap<String, List<PortletConfigurationIcon>> _serviceTrackerMap = ServiceTrackerCollections.openMultiValueMap(PortletConfigurationIcon.class, null, (ServiceReferenceMapper)new PortletConfigurationIconServiceReferenceMapper());

    public static List<PortletConfigurationIcon> getPortletConfigurationIcons(String portletId, PortletRequest portletRequest) {
        return PortletConfigurationIconTracker._getPortletConfigurationIcons(portletId, portletRequest, false);
    }

    public static List<PortletConfigurationIcon> getPortletConfigurationIcons(String portletId, PortletRequest portletRequest, Comparator<?> comparator) {
        List<PortletConfigurationIcon> portletConfigurationIcons = PortletConfigurationIconTracker._getPortletConfigurationIcons(portletId, portletRequest, true);
        Collections.sort(portletConfigurationIcons, comparator);
        return portletConfigurationIcons;
    }

    protected static String getKey(String portletId, String path) {
        return portletId.concat(":").concat(path);
    }

    protected static Set<String> getPaths(String portletId, PortletRequest portletRequest) {
        Set<String> paths = _defaultPaths;
        for (PortletConfigurationIconLocator portletConfigurationIconLocator : _serviceTrackerList) {
            List<String> defaultViews;
            String path = portletConfigurationIconLocator.getPath(portletRequest);
            if (path.isEmpty()) continue;
            if (paths == _defaultPaths) {
                paths = new HashSet<String>();
            }
            paths.add(path);
            if (path.equals("-") || !(defaultViews = portletConfigurationIconLocator.getDefaultViews(portletId)).contains(path)) continue;
            paths.add("-");
        }
        return paths;
    }

    private static List<PortletConfigurationIcon> _getPortletConfigurationIcons(String portletId, PortletRequest portletRequest, boolean filter) {
        ArrayList<PortletConfigurationIcon> portletConfigurationIcons = new ArrayList<PortletConfigurationIcon>();
        if (portletRequest == null) {
            return portletConfigurationIcons;
        }
        final ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletRequestWrapper portletRequestWrapper = new PortletRequestWrapper(portletRequest){

            public Object getAttribute(String name) {
                if (Objects.equals(name, "LIFERAY_SHARED_THEME_DISPLAY")) {
                    return themeDisplay;
                }
                return super.getAttribute(name);
            }
        };
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(portletRequest));
        String layoutMode = ParamUtil.getString(originalHttpServletRequest, "p_l_mode", "view");
        for (String path : PortletConfigurationIconTracker.getPaths(portletId, portletRequest)) {
            List portletPortletConfigurationIcons = (List)_serviceTrackerMap.getService((Object)PortletConfigurationIconTracker.getKey("*", path));
            if (portletPortletConfigurationIcons != null) {
                for (PortletConfigurationIcon portletConfigurationIcon : portletPortletConfigurationIcons) {
                    if (Objects.equals(layoutMode, "edit") && !portletConfigurationIcon.isShowInEditMode(portletRequest) || filter && !portletConfigurationIcon.isShow((PortletRequest)portletRequestWrapper)) continue;
                    portletConfigurationIcons.add(portletConfigurationIcon);
                }
            }
            if ((portletPortletConfigurationIcons = (List)_serviceTrackerMap.getService((Object)PortletConfigurationIconTracker.getKey(portletId, path))) == null) continue;
            for (PortletConfigurationIcon portletConfigurationIcon : portletPortletConfigurationIcons) {
                if (Objects.equals(layoutMode, "edit") && !portletConfigurationIcon.isShowInEditMode((PortletRequest)portletRequestWrapper) || portletConfigurationIcons.contains(portletConfigurationIcon) || filter && !portletConfigurationIcon.isShow((PortletRequest)portletRequestWrapper)) continue;
                portletConfigurationIcons.add(portletConfigurationIcon);
            }
        }
        return portletConfigurationIcons;
    }
}

