/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelist;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import javax.servlet.http.HttpServletRequest;

public class AuthTokenWhitelistUtil {
    private static final ServiceTrackerList<AuthTokenWhitelist> _authTokenWhitelists = ServiceTrackerCollections.openList(AuthTokenWhitelist.class);

    public static boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isOriginCSRFWhitelisted(companyId, origin)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletCSRFWhitelisted(httpServletRequest, portlet)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletInvocationWhitelisted(httpServletRequest, portlet)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletURLCSRFWhitelisted(liferayPortletURL)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletURLPortletInvocationWhitelisted(liferayPortletURL)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidSharedSecret(String sharedSecret) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isValidSharedSecret(sharedSecret)) continue;
            return true;
        }
        return false;
    }
}

