/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.ui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class BreadcrumbUtil {
    public static final int ENTRY_TYPE_ANY = 0;
    public static final int ENTRY_TYPE_CURRENT_GROUP = 1;
    public static final int ENTRY_TYPE_GUEST_GROUP = 2;
    public static final int ENTRY_TYPE_LAYOUT = 3;
    public static final int ENTRY_TYPE_PARENT_GROUP = 4;
    public static final int ENTRY_TYPE_PORTLET = 5;

    public static List<BreadcrumbEntry> getBreadcrumbEntries(HttpServletRequest httpServletRequest, int[] types) throws Exception {
        BreadcrumbEntry breadcrumbEntry;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        boolean hasAll = ArrayUtil.contains(types, 0);
        if ((hasAll || ArrayUtil.contains(types, 2)) && (breadcrumbEntry = BreadcrumbUtil.getGuestGroupBreadcrumbEntry(themeDisplay)) != null) {
            breadcrumbEntries.add(breadcrumbEntry);
        }
        if (hasAll || ArrayUtil.contains(types, 4)) {
            breadcrumbEntries.addAll(BreadcrumbUtil.getParentGroupBreadcrumbEntries(themeDisplay));
        }
        if ((hasAll || ArrayUtil.contains(types, 1)) && (breadcrumbEntry = BreadcrumbUtil.getScopeGroupBreadcrumbEntry(themeDisplay)) != null) {
            breadcrumbEntries.add(breadcrumbEntry);
        }
        if (hasAll || ArrayUtil.contains(types, 3)) {
            breadcrumbEntries.addAll(BreadcrumbUtil.getLayoutBreadcrumbEntries(themeDisplay));
        }
        if (hasAll || ArrayUtil.contains(types, 5)) {
            breadcrumbEntries.addAll(BreadcrumbUtil.getPortletBreadcrumbEntries(httpServletRequest));
        }
        return breadcrumbEntries;
    }

    public static BreadcrumbEntry getGuestGroupBreadcrumbEntry(ThemeDisplay themeDisplay) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup(themeDisplay.getCompanyId(), "Guest");
        if (group.getPublicLayoutsPageCount() == 0) {
            return null;
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(group.getGroupId(), false);
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        Account account = themeDisplay.getAccount();
        breadcrumbEntry.setTitle(account.getName());
        String layoutSetFriendlyURL = PortalUtil.getLayoutSetFriendlyURL(layoutSet, themeDisplay);
        if (themeDisplay.isAddSessionIdToURL()) {
            layoutSetFriendlyURL = PortalUtil.getURLWithSessionId(layoutSetFriendlyURL, themeDisplay.getSessionId());
        }
        breadcrumbEntry.setURL(layoutSetFriendlyURL);
        return breadcrumbEntry;
    }

    public static List<BreadcrumbEntry> getLayoutBreadcrumbEntries(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (!group.isLayoutPrototype()) {
            BreadcrumbUtil._addLayoutBreadcrumbEntries(breadcrumbEntries, themeDisplay, layout);
        }
        return breadcrumbEntries;
    }

    public static List<BreadcrumbEntry> getParentGroupBreadcrumbEntries(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        Layout layout = themeDisplay.getLayout();
        LayoutSet parentLayoutSet = BreadcrumbUtil._getParentLayoutSet(layout.getLayoutSet());
        if (parentLayoutSet != null) {
            BreadcrumbUtil._addGroupsBreadcrumbEntries(breadcrumbEntries, themeDisplay, parentLayoutSet, true);
        }
        return breadcrumbEntries;
    }

    public static List<BreadcrumbEntry> getPortletBreadcrumbEntries(HttpServletRequest httpServletRequest) {
        List portletBreadcrumbEntries;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String name = "LIFERAY_SHARED_PORTLET_BREADCRUMBS";
        List breadcrumbEntries = (List)httpServletRequest.getAttribute(name);
        if (Validator.isNotNull(portletDisplay.getId()) && !portletDisplay.isFocused() && !Objects.equals(portletDisplay.getId(), PortletProviderUtil.getPortletId(BreadcrumbEntry.class.getName(), PortletProvider.Action.VIEW)) && (portletBreadcrumbEntries = (List)httpServletRequest.getAttribute(name = name.concat("_".concat(portletDisplay.getId())))) != null) {
            breadcrumbEntries = portletBreadcrumbEntries;
        }
        if (breadcrumbEntries == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < breadcrumbEntries.size() - 1; ++i) {
            BreadcrumbEntry portletBreadcrumbEntry = (BreadcrumbEntry)breadcrumbEntries.get(i);
            String url = portletBreadcrumbEntry.getURL();
            if (!Validator.isNotNull(url) || CookieKeys.hasSessionId(httpServletRequest)) continue;
            HttpSession session = httpServletRequest.getSession();
            portletBreadcrumbEntry.setURL(PortalUtil.getURLWithSessionId(url, session.getId()));
        }
        return breadcrumbEntries;
    }

    public static BreadcrumbEntry getScopeGroupBreadcrumbEntry(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        Layout layout = themeDisplay.getLayout();
        BreadcrumbUtil._addGroupsBreadcrumbEntries(breadcrumbEntries, themeDisplay, layout.getLayoutSet(), false);
        if (breadcrumbEntries.isEmpty()) {
            return null;
        }
        return (BreadcrumbEntry)breadcrumbEntries.get(0);
    }

    private static void _addGroupsBreadcrumbEntries(List<BreadcrumbEntry> breadcrumbEntries, ThemeDisplay themeDisplay, LayoutSet layoutSet, boolean includeParentGroups) throws Exception {
        LayoutSet parentLayoutSet;
        Group group = layoutSet.getGroup();
        if (group.isControlPanel()) {
            return;
        }
        if (includeParentGroups && (parentLayoutSet = BreadcrumbUtil._getParentLayoutSet(layoutSet)) != null) {
            BreadcrumbUtil._addGroupsBreadcrumbEntries(breadcrumbEntries, themeDisplay, parentLayoutSet, true);
        }
        int layoutsPageCount = 0;
        layoutsPageCount = layoutSet.isPrivateLayout() ? group.getPrivateLayoutsPageCount() : group.getPublicLayoutsPageCount();
        if (layoutsPageCount > 0 && !group.isGuest()) {
            String layoutSetFriendlyURL = PortalUtil.getLayoutSetFriendlyURL(layoutSet, themeDisplay);
            if (themeDisplay.isAddSessionIdToURL()) {
                layoutSetFriendlyURL = PortalUtil.getURLWithSessionId(layoutSetFriendlyURL, themeDisplay.getSessionId());
            }
            BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
            breadcrumbEntry.setTitle(group.getDescriptiveName(themeDisplay.getLocale()));
            breadcrumbEntry.setURL(layoutSetFriendlyURL);
            breadcrumbEntries.add(breadcrumbEntry);
        }
    }

    private static void _addLayoutBreadcrumbEntries(List<BreadcrumbEntry> breadcrumbEntries, ThemeDisplay themeDisplay, Layout layout) throws Exception {
        if (layout.getParentLayoutId() != 0L) {
            BreadcrumbUtil._addLayoutBreadcrumbEntries(breadcrumbEntries, themeDisplay, LayoutLocalServiceUtil.getParentLayout(layout));
        }
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setBaseModel(layout);
        LayoutType layoutType = layout.getLayoutType();
        if (!layoutType.isBrowsable()) {
            breadcrumbEntry.setBrowsable(false);
        }
        String layoutName = layout.getName(themeDisplay.getLocale());
        if (layout.isTypeControlPanel() && layoutName.equals("Control Panel")) {
            layoutName = LanguageUtil.get(themeDisplay.getLocale(), "control-panel");
        }
        breadcrumbEntry.setTitle(layoutName);
        String layoutURL = PortalUtil.getLayoutFullURL(layout, themeDisplay);
        if (themeDisplay.isAddSessionIdToURL()) {
            layoutURL = PortalUtil.getURLWithSessionId(layoutURL, themeDisplay.getSessionId());
        }
        breadcrumbEntry.setURL(layoutURL);
        breadcrumbEntries.add(breadcrumbEntry);
    }

    private static LayoutSet _getParentLayoutSet(LayoutSet layoutSet) throws Exception {
        User user;
        List<Organization> organizations;
        Group group = layoutSet.getGroup();
        if (group.isSite()) {
            Group parentGroup = group.getParentGroup();
            if (parentGroup != null) {
                return LayoutSetLocalServiceUtil.getLayoutSet(parentGroup.getGroupId(), layoutSet.isPrivateLayout());
            }
        } else if (group.isUser() && !(organizations = OrganizationLocalServiceUtil.getUserOrganizations((user = UserLocalServiceUtil.getUser(group.getClassPK())).getUserId())).isEmpty()) {
            Organization organization = organizations.get(0);
            Group parentGroup = organization.getGroup();
            return LayoutSetLocalServiceUtil.getLayoutSet(parentGroup.getGroupId(), layoutSet.isPrivateLayout());
        }
        return null;
    }
}

