/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.SettingsLocatorHelperUtil;

public class GroupServiceSettingsLocator
implements SettingsLocator {
    private final String _configurationPid;
    private final long _groupId;
    private final String _settingsId;
    private final SettingsLocatorHelper _settingsLocatorHelper = SettingsLocatorHelperUtil.getSettingsLocatorHelper();

    public GroupServiceSettingsLocator(long groupId, String settingsId) {
        this(groupId, settingsId, settingsId);
    }

    public GroupServiceSettingsLocator(long groupId, String settingsId, String configurationPid) {
        this._groupId = groupId;
        this._settingsId = settingsId;
        this._configurationPid = configurationPid;
    }

    @Override
    public Settings getSettings() throws SettingsException {
        CompanyServiceSettingsLocator companyServiceSettingsLocator = new CompanyServiceSettingsLocator(this.getCompanyId(this._groupId), this._settingsId, this._configurationPid);
        Settings groupConfigurationBeanSettings = this._settingsLocatorHelper.getGroupConfigurationBeanSettings(this._groupId, this._configurationPid, companyServiceSettingsLocator.getSettings());
        return this._settingsLocatorHelper.getGroupPortletPreferencesSettings(this._groupId, this._settingsId, groupConfigurationBeanSettings);
    }

    @Override
    public String getSettingsId() {
        return this._settingsId;
    }

    protected long getCompanyId(long groupId) throws SettingsException {
        try {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            return group.getCompanyId();
        }
        catch (PortalException pe) {
            throw new SettingsException(pe);
        }
    }
}

