/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupFriendlyURLComparator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WebDAVUtil {
    public static final Namespace DAV_URI = SAXReaderUtil.createNamespace("D", "DAV:");
    public static final int SC_LOCKED = 423;
    public static final int SC_MULTI_STATUS = 207;
    public static final String TOKEN_PREFIX = "opaquelocktoken:";
    private static final String _TIME_PREFIX = "Second-";
    private static final Log _log = LogFactoryUtil.getLog(WebDAVUtil.class);
    private static final WebDAVUtil _instance = new WebDAVUtil();
    private final ServiceRegistrationMap<WebDAVStorage> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTrackerMap<String, WebDAVStorage> _storages = ServiceTrackerCollections.openSingleValueMap(WebDAVStorage.class, (String)"webdav.storage.token", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<WebDAVStorage, WebDAVStorage>(){

        public WebDAVStorage addingService(ServiceReference<WebDAVStorage> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            WebDAVStorage webDAVStorage = (WebDAVStorage)registry.getService(serviceReference);
            this.setToken(serviceReference, webDAVStorage);
            return webDAVStorage;
        }

        public void modifiedService(ServiceReference<WebDAVStorage> serviceReference, WebDAVStorage webDAVStorage) {
            this.setToken(serviceReference, webDAVStorage);
        }

        public void removedService(ServiceReference<WebDAVStorage> serviceReference, WebDAVStorage webDAVStorage) {
        }

        protected void setToken(ServiceReference<WebDAVStorage> serviceReference, WebDAVStorage webDAVStorage) {
            String token = (String)serviceReference.getProperty("webdav.storage.token");
            webDAVStorage.setToken(token);
        }
    });

    public static void addStorage(WebDAVStorage storage) {
        WebDAVUtil.getInstance()._addStorage(storage);
    }

    public static Namespace createNamespace(String prefix, String uri) {
        Namespace namespace = null;
        namespace = uri.equals(DAV_URI.getURI()) ? DAV_URI : (Validator.isNull(prefix) ? SAXReaderUtil.createNamespace(uri) : SAXReaderUtil.createNamespace(prefix, uri));
        return namespace;
    }

    public static void deleteStorage(WebDAVStorage storage) {
        WebDAVUtil.getInstance()._deleteStorage(storage);
    }

    public static long getDepth(HttpServletRequest httpServletRequest) {
        String value = GetterUtil.getString(httpServletRequest.getHeader("Depth"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Depth\" header is " + value);
        }
        if (value.equals("0")) {
            return 0L;
        }
        return -1L;
    }

    public static String getDestination(HttpServletRequest httpServletRequest, String rootPath) {
        String headerDestination = httpServletRequest.getHeader("Destination");
        String[] pathSegments = StringUtil.split(headerDestination, rootPath);
        String destination = pathSegments[pathSegments.length - 1];
        destination = HttpUtil.decodePath(destination);
        if (_log.isDebugEnabled()) {
            _log.debug("Destination " + destination);
        }
        return destination;
    }

    public static long getGroupId(long companyId, String path) throws WebDAVException {
        return WebDAVUtil.getGroupId(companyId, WebDAVUtil.getPathArray(path));
    }

    public static long getGroupId(long companyId, String[] pathArray) throws WebDAVException {
        try {
            if (pathArray.length == 0) {
                return 0L;
            }
            String name = pathArray[0];
            Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + name);
            if (group != null) {
                return group.getGroupId();
            }
            User user = UserLocalServiceUtil.fetchUserByScreenName(companyId, name);
            if (user != null) {
                group = user.getGroup();
                return group.getGroupId();
            }
        }
        catch (Exception e) {
            throw new WebDAVException(e);
        }
        return 0L;
    }

    public static List<Group> getGroups(long userId) throws Exception {
        return WebDAVUtil.getGroups(UserLocalServiceUtil.getUser(userId));
    }

    public static List<Group> getGroups(User user) throws Exception {
        if (user.isDefaultUser()) {
            ArrayList<Group> groups = new ArrayList<Group>();
            Group group = GroupLocalServiceUtil.getGroup(user.getCompanyId(), "Guest");
            groups.add(group);
            return groups;
        }
        HashSet<Group> groups = new HashSet<Group>();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", user.getUserId());
        GroupFriendlyURLComparator orderByComparator = new GroupFriendlyURLComparator(true);
        groups.addAll(GroupLocalServiceUtil.search(user.getCompanyId(), null, null, params, -1, -1, (OrderByComparator<Group>)orderByComparator));
        groups.addAll(GroupLocalServiceUtil.getUserOrganizationsGroups(user.getUserId(), -1, -1));
        if (!user.isDefaultUser()) {
            groups.add(user.getGroup());
        }
        ArrayList<Group> groupsList = new ArrayList<Group>(groups);
        Collections.sort(groupsList, orderByComparator);
        return groupsList;
    }

    public static WebDAVUtil getInstance() {
        return _instance;
    }

    public static String getLockUuid(HttpServletRequest httpServletRequest) throws WebDAVException {
        String token = "";
        String value = GetterUtil.getString(httpServletRequest.getHeader("If"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"If\" header is " + value);
        }
        if (value.contains("(<DAV:no-lock>)")) {
            if (_log.isWarnEnabled()) {
                _log.warn("Lock tokens can never be <DAV:no-lock>");
            }
            throw new WebDAVException();
        }
        int beg = value.indexOf(TOKEN_PREFIX);
        if (beg >= 0 && (beg += TOKEN_PREFIX.length()) < value.length()) {
            int end = value.indexOf(62, beg);
            token = GetterUtil.getString(value.substring(beg, end));
        }
        return token;
    }

    public static String[] getPathArray(String path) {
        return WebDAVUtil.getPathArray(path, false);
    }

    public static String[] getPathArray(String path, boolean fixTrailing) {
        path = HttpUtil.fixPath(path, true, fixTrailing);
        return StringUtil.split(path, '/');
    }

    public static String getResourceName(String[] pathArray) {
        if (pathArray.length <= 2) {
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public static WebDAVStorage getStorage(String token) {
        return WebDAVUtil.getInstance()._getStorage(token);
    }

    public static String getStorageToken(Portlet portlet) {
        WebDAVStorage webDAVStorageInstance = portlet.getWebDAVStorageInstance();
        if (webDAVStorageInstance == null) {
            return null;
        }
        return webDAVStorageInstance.getToken();
    }

    public static Collection<String> getStorageTokens() {
        return WebDAVUtil.getInstance()._getStorageTokens();
    }

    public static long getTimeout(HttpServletRequest httpServletRequest) {
        int index;
        long timeout = 0L;
        String value = GetterUtil.getString(httpServletRequest.getHeader("Timeout"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Timeout\" header is " + value);
        }
        if ((index = value.indexOf(_TIME_PREFIX)) >= 0 && (index += _TIME_PREFIX.length()) < value.length()) {
            timeout = GetterUtil.getLong(value.substring(index));
        }
        return timeout * 1000L;
    }

    public static boolean isOverwrite(HttpServletRequest httpServletRequest) {
        return WebDAVUtil.getInstance()._isOverwrite(httpServletRequest);
    }

    public static String stripManualCheckInRequiredPath(String url) {
        return WebDAVUtil.stripToken(url, "/manualCheckInRequired");
    }

    public static String stripOfficeExtension(String url) {
        String strippedUrl = WebDAVUtil.stripToken(url, "/officeExtension");
        if (strippedUrl.length() != url.length()) {
            strippedUrl = FileUtil.stripExtension(strippedUrl);
        }
        return strippedUrl;
    }

    public static String stripToken(String url, String token) {
        if (Validator.isNull(url)) {
            return "";
        }
        int index = url.indexOf(token);
        if (index >= 0) {
            url = url.substring(0, index) + url.substring(index + token.length());
        }
        return url;
    }

    private WebDAVUtil() {
    }

    private void _addStorage(WebDAVStorage storage) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(WebDAVStorage.class, (Object)storage);
        this._serviceRegistrations.put((Object)storage, (Object)serviceRegistration);
    }

    private void _deleteStorage(WebDAVStorage storage) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)storage);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private WebDAVStorage _getStorage(String token) {
        return (WebDAVStorage)this._storages.getService((Object)token);
    }

    private Collection<String> _getStorageTokens() {
        return this._storages.keySet();
    }

    private boolean _isOverwrite(HttpServletRequest httpServletRequest) {
        String value = GetterUtil.getString(httpServletRequest.getHeader("Overwrite"));
        return !StringUtil.equalsIgnoreCase(value, "F") && GetterUtil.getBoolean(value);
    }
}

