/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;

public class PortalBeanLocatorUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortalBeanLocatorUtil.class);
    private static BeanLocator _beanLocator;

    public static BeanLocator getBeanLocator() {
        return _beanLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Map<String, T> locate(Class<T> clazz) {
        BeanLocator beanLocator = PortalBeanLocatorUtil.getBeanLocator();
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator is not set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader beanClassLoader = beanLocator.getClassLoader();
        try {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(beanClassLoader);
            }
            Map<String, T> map = beanLocator.locate(clazz);
            return map;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object locate(String name) {
        BeanLocator beanLocator = PortalBeanLocatorUtil.getBeanLocator();
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator is not set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader beanClassLoader = beanLocator.getClassLoader();
        try {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(beanClassLoader);
            }
            Object object = beanLocator.locate(name);
            return object;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public static void reset() {
        PortalBeanLocatorUtil.setBeanLocator(null);
    }

    public static void setBeanLocator(BeanLocator beanLocator) {
        if (_log.isDebugEnabled()) {
            if (beanLocator == null) {
                _log.debug("Setting BeanLocator " + beanLocator);
            } else {
                _log.debug("Setting BeanLocator " + beanLocator.hashCode());
            }
        }
        _beanLocator = beanLocator;
    }

    @Deprecated
    public static interface PACL {
        public ClassLoader getBeanLocatorClassLoader(BeanLocator var1);

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);
    }
}

