/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.service.persistence;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.internal.service.persistence.TableMapperImpl;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Collections;
import java.util.List;

public class CachelessTableMapperImpl<L extends BaseModel<L>, R extends BaseModel<R>>
extends TableMapperImpl<L, R> {
    protected final MappingSqlQuery<Integer> getTableMappingSqlQuery;

    public CachelessTableMapperImpl(String tableName, String companyColumnName, String leftColumnName, String rightColumnName, Class<L> leftModelClass, Class<R> rightModelClass, BasePersistence<L> leftBasePersistence, BasePersistence<R> rightBasePersistence) {
        super(tableName, companyColumnName, leftColumnName, rightColumnName, leftModelClass, rightModelClass, leftBasePersistence, rightBasePersistence);
        this.getTableMappingSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(leftBasePersistence.getDataSource(), StringBundler.concat("SELECT * FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ?"), RowMapper.COUNT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.destroy();
        this.leftToRightPortalCache = new DummyPortalCache(this.leftToRightPortalCache.getPortalCacheName(), this.leftToRightPortalCache.getPortalCacheManager());
        this.rightToLeftPortalCache = new DummyPortalCache(this.rightToLeftPortalCache.getPortalCacheName(), this.rightToLeftPortalCache.getPortalCacheManager());
    }

    @Override
    protected boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey, boolean updateCache) {
        List<Integer> counts = null;
        try {
            counts = this.getTableMappingSqlQuery.execute(leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (counts.isEmpty()) {
            return false;
        }
        int count = counts.get(0);
        return count != 0;
    }

    protected static class DummyPortalCache
    implements PortalCache<Long, long[]> {
        protected final PortalCacheManager<Long, long[]> portalCacheManager;
        protected final String portalCacheName;

        @Override
        public long[] get(Long key) {
            return null;
        }

        @Override
        public List<Long> getKeys() {
            return Collections.emptyList();
        }

        @Override
        public PortalCacheManager<Long, long[]> getPortalCacheManager() {
            return this.portalCacheManager;
        }

        @Override
        public String getPortalCacheName() {
            return this.portalCacheName;
        }

        @Override
        public boolean isBlocking() {
            return false;
        }

        @Override
        public boolean isMVCC() {
            return false;
        }

        @Override
        public void put(Long key, long[] value) {
        }

        @Override
        public void put(Long key, long[] value, int timeToLive) {
        }

        @Override
        public void registerPortalCacheListener(PortalCacheListener<Long, long[]> portalCacheListener) {
        }

        @Override
        public void registerPortalCacheListener(PortalCacheListener<Long, long[]> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
        }

        @Override
        public void remove(Long key) {
        }

        @Override
        public void removeAll() {
        }

        @Override
        public void unregisterPortalCacheListener(PortalCacheListener<Long, long[]> portalCacheListener) {
        }

        @Override
        public void unregisterPortalCacheListeners() {
        }

        protected DummyPortalCache(String portalCacheName, PortalCacheManager<Long, long[]> portalCacheManager) {
            this.portalCacheName = portalCacheName;
            this.portalCacheManager = portalCacheManager;
        }
    }
}

