/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseDestination
implements Destination {
    protected Set<MessageListener> messageListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected String name = "";
    private final Set<DestinationEventListener> _destinationEventListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean addDestinationEventListener(DestinationEventListener destinationEventListener) {
        return this._destinationEventListeners.add(destinationEventListener);
    }

    public void afterPropertiesSet() {
        if (Validator.isNull(this.name)) {
            throw new IllegalArgumentException("Name is null");
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean force) {
    }

    @Override
    public void copyDestinationEventListeners(Destination destination) {
        for (DestinationEventListener destinationEventListener : this._destinationEventListeners) {
            destination.addDestinationEventListener(destinationEventListener);
        }
    }

    @Override
    public void copyMessageListeners(Destination destination) {
        for (MessageListener messageListener : this.messageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)messageListener;
            destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
        }
    }

    @Override
    public void destroy() {
        this.close(true);
        this.removeDestinationEventListeners();
        this.unregisterMessageListeners();
    }

    @Override
    public DestinationStatistics getDestinationStatistics() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMessageListenerCount() {
        return this.messageListeners.size();
    }

    @Override
    public Set<MessageListener> getMessageListeners() {
        return Collections.unmodifiableSet(this.messageListeners);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRegistered() {
        return this.getMessageListenerCount() > 0;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean register(MessageListener messageListener) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener);
        return this.registerMessageListener(invokerMessageListener);
    }

    @Override
    public boolean register(MessageListener messageListener, ClassLoader classLoader) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener, classLoader);
        return this.registerMessageListener(invokerMessageListener);
    }

    @Override
    public boolean removeDestinationEventListener(DestinationEventListener destinationEventListener) {
        return this._destinationEventListeners.remove(destinationEventListener);
    }

    @Override
    public void removeDestinationEventListeners() {
        this._destinationEventListeners.clear();
    }

    @Override
    public void send(Message message) {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean unregister(MessageListener messageListener) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener);
        return this.unregisterMessageListener(invokerMessageListener);
    }

    public boolean unregister(MessageListener messageListener, ClassLoader classLoader) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener, classLoader);
        return this.unregisterMessageListener(invokerMessageListener);
    }

    @Override
    public void unregisterMessageListeners() {
        for (MessageListener messageListener : this.messageListeners) {
            this.unregisterMessageListener((InvokerMessageListener)messageListener);
        }
    }

    protected void fireMessageListenerRegisteredEvent(MessageListener messageListener) {
        for (DestinationEventListener destinationEventListener : this._destinationEventListeners) {
            destinationEventListener.messageListenerRegistered(this.getName(), messageListener);
        }
    }

    protected void fireMessageListenerUnregisteredEvent(MessageListener messageListener) {
        for (DestinationEventListener listener : this._destinationEventListeners) {
            listener.messageListenerUnregistered(this.getName(), messageListener);
        }
    }

    protected boolean registerMessageListener(InvokerMessageListener invokerMessageListener) {
        boolean registered = this.messageListeners.add(invokerMessageListener);
        if (registered) {
            this.fireMessageListenerRegisteredEvent(invokerMessageListener.getMessageListener());
        }
        return registered;
    }

    protected boolean unregisterMessageListener(InvokerMessageListener invokerMessageListener) {
        boolean unregistered = this.messageListeners.remove(invokerMessageListener);
        if (unregistered) {
            this.fireMessageListenerUnregisteredEvent(invokerMessageListener.getMessageListener());
        }
        return unregistered;
    }
}

