/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.config;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginSchedulingConfigurator {
    private static final Log _log = LogFactoryUtil.getLog(PluginSchedulingConfigurator.class);
    private final Map<String, MessageListener> _messageListeners = new HashMap<String, MessageListener>();
    private List<SchedulerEntry> _schedulerEntries = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        boolean forceSync = ProxyModeThreadLocal.isForceSync();
        ProxyModeThreadLocal.setForceSync(true);
        try {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            currentThread.setContextClassLoader(portalClassLoader);
            for (SchedulerEntry schedulerEntry : this._schedulerEntries) {
                try {
                    MessageListener messageListener = (MessageListener)InstanceFactory.newInstance(PortletClassLoaderUtil.getClassLoader(), schedulerEntry.getEventListenerClass());
                    SchedulerEngineHelperUtil.register(messageListener, schedulerEntry, "liferay/scheduler_dispatch");
                    this._messageListeners.put(schedulerEntry.getEventListenerClass(), messageListener);
                }
                catch (Exception e) {
                    _log.error("Unable to schedule " + schedulerEntry, e);
                }
            }
        }
        finally {
            ProxyModeThreadLocal.setForceSync(forceSync);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void destroy() {
        for (MessageListener messageListener : this._messageListeners.values()) {
            SchedulerEngineHelperUtil.unregister(messageListener);
        }
        this._messageListeners.clear();
        this._schedulerEntries.clear();
    }

    public void setSchedulerEntries(List<SchedulerEntry> schedulerEntries) {
        this._schedulerEntries = schedulerEntries;
    }
}

