/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicInclude;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TagDynamicIncludeUtil {
    private static final Log _log = LogFactoryUtil.getLog(TagDynamicIncludeUtil.class);
    private static final TagDynamicIncludeUtil _instance = new TagDynamicIncludeUtil();
    private final ServiceTrackerMap<String, List<TagDynamicInclude>> _tagDynamicIncludes = ServiceTrackerCollections.openMultiValueMap(TagDynamicInclude.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, TagDynamicInclude>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<TagDynamicInclude> serviceReference, final ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            TagDynamicInclude tagDynamicInclude = (TagDynamicInclude)registry.getService(serviceReference);
            try {
                tagDynamicInclude.register(new TagDynamicInclude.TagDynamicIncludeRegistry(){

                    @Override
                    public void register(String tagClassName, String tagDynamicId, String tagPoint) {
                        String key = TagDynamicIncludeUtil._getKey(tagClassName, tagDynamicId, tagPoint);
                        emitter.emit((Object)key);
                    }
                });
            }
            finally {
                registry.ungetService(serviceReference);
            }
        }
    });

    public static List<TagDynamicInclude> getTagDynamicIncludes(String tagClassName, String tagDynamicId, String tagPoint) {
        String key = TagDynamicIncludeUtil._getKey(tagClassName, tagDynamicId, tagPoint);
        return (List)TagDynamicIncludeUtil._instance._tagDynamicIncludes.getService((Object)key);
    }

    public static boolean hasTagDynamicInclude(String tagClassName, String tagDynamicId, String tagPoint) {
        List<TagDynamicInclude> tagDynamicIncludes = TagDynamicIncludeUtil.getTagDynamicIncludes(tagClassName, tagDynamicId, tagPoint);
        return tagDynamicIncludes != null && !tagDynamicIncludes.isEmpty();
    }

    public static void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String tagClassName, String tagDynamicId, String tagPoint, boolean ascendingPriority) {
        List<TagDynamicInclude> tagDynamicIncludes = TagDynamicIncludeUtil.getTagDynamicIncludes(tagClassName, tagDynamicId, tagPoint);
        if (tagDynamicIncludes == null || tagDynamicIncludes.isEmpty()) {
            return;
        }
        Iterator<TagDynamicInclude> iterator = null;
        iterator = ascendingPriority ? tagDynamicIncludes.iterator() : ListUtil.reverseIterator(tagDynamicIncludes);
        while (iterator.hasNext()) {
            TagDynamicInclude tagDynamicInclude = iterator.next();
            try {
                tagDynamicInclude.include(httpServletRequest, httpServletResponse, tagClassName, tagDynamicId, tagPoint);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    private static String _getKey(String tagClassName, String tagDynamicId, String tagPoint) {
        StringBundler sb = new StringBundler(5);
        sb.append(tagClassName);
        sb.append('#');
        sb.append(tagPoint);
        sb.append('#');
        sb.append(tagDynamicId);
        return sb.toString();
    }

    private TagDynamicIncludeUtil() {
    }
}

