/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Map;

public class BaseUpgradeSQLServerDatetime
extends UpgradeProcess {
    private static final int _NEW_SIZE = 6;
    private static final String _NEW_TYPE = "datetime2";
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradeSQLServerDatetime.class);
    private final Class<?>[] _tableClasses;

    public BaseUpgradeSQLServerDatetime(Class<?>[] tableClasses) {
        this._tableClasses = tableClasses;
    }

    @Override
    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.SQLSERVER) {
            return;
        }
        for (Class<?> tableClass : this._tableClasses) {
            this._upgradeTable(tableClass);
        }
    }

    private void _upgradeTable(Class<?> tableClass) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        String catalog = dbInspector.getCatalog();
        String schema = dbInspector.getSchema();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        String tableName = dbInspector.normalizeName(this.getTableName(tableClass), databaseMetaData);
        try (ResultSet tableRS = databaseMetaData.getTables(catalog, schema, tableName, null);){
            if (!tableRS.next()) {
                _log.error(StringBundler.concat((String[])new String[]{"Table ", tableName, " does not exist"}));
                return;
            }
            String newTypeName = dbInspector.normalizeName(_NEW_TYPE);
            String newTypeDefinition = StringBundler.concat((Object[])new Object[]{newTypeName, "(", 6, ")"});
            Map<String, Integer> tableColumnMap = this.getTableColumnsMap(tableClass);
            for (Map.Entry<String, Integer> entry : tableColumnMap.entrySet()) {
                if (entry.getValue() != 93) continue;
                String columnName = dbInspector.normalizeName(entry.getKey(), databaseMetaData);
                ResultSet columnRS = databaseMetaData.getColumns(null, null, tableName, columnName);
                Throwable throwable = null;
                try {
                    if (!columnRS.next()) {
                        _log.error(StringBundler.concat((String[])new String[]{"Column ", columnName, " does not exist in table ", tableName}));
                        continue;
                    }
                    if (newTypeName.equals(columnRS.getString("TYPE_NAME")) && 6 == columnRS.getInt("DECIMAL_DIGITS")) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn(StringBundler.concat((String[])new String[]{"Column ", columnName, " in table ", tableName, " already is ", newTypeDefinition}));
                        continue;
                    }
                    this.alter(tableClass, new UpgradeProcess.AlterColumnType(this, columnName, newTypeDefinition));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (columnRS == null) continue;
                    if (throwable != null) {
                        try {
                            columnRS.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    columnRS.close();
                }
            }
        }
    }
}

