/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetRendererFactoryRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(AssetRendererFactoryRegistryUtil.class);
    private static final Map<String, AssetRendererFactory<?>> _assetRenderFactoriesMapByClassName = new ConcurrentHashMap();
    private static final Map<String, AssetRendererFactory<?>> _assetRenderFactoriesMapByClassType = new ConcurrentHashMap();
    private static final ServiceRegistrationMap<AssetRendererFactory<?>> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private static final ServiceTracker<AssetRendererFactory<?>, AssetRendererFactory<?>> _serviceTracker;

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId) {
        return ListUtil.fromMapValues(AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, _assetRenderFactoriesMapByClassName, false));
    }

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId, boolean filterSelectable) {
        return ListUtil.fromMapValues(AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, _assetRenderFactoriesMapByClassName, filterSelectable));
    }

    public static <T> AssetRendererFactory<T> getAssetRendererFactoryByClass(Class<T> clazz) {
        return _assetRenderFactoriesMapByClassName.get(clazz.getName());
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByClassName(String className) {
        return _assetRenderFactoriesMapByClassName.get(className);
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByClassNameId(long classNameId) {
        return _assetRenderFactoriesMapByClassName.get(PortalUtil.getClassName(classNameId));
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByType(String type) {
        return _assetRenderFactoriesMapByClassType.get(type);
    }

    public static long[] getClassNameIds(long companyId) {
        return AssetRendererFactoryRegistryUtil.getClassNameIds(companyId, false);
    }

    public static long[] getClassNameIds(long companyId, boolean filterSelectable) {
        Map<String, AssetRendererFactory<?>> assetRenderFactories = _assetRenderFactoriesMapByClassName;
        if (companyId > 0L) {
            assetRenderFactories = AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, _assetRenderFactoriesMapByClassName, filterSelectable);
        }
        long[] classNameIds = new long[assetRenderFactories.size()];
        int i = 0;
        for (AssetRendererFactory<?> assetRendererFactory : assetRenderFactories.values()) {
            classNameIds[i] = assetRendererFactory.getClassNameId();
            ++i;
        }
        return classNameIds;
    }

    public static void register(AssetRendererFactory<?> assetRendererFactory) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(AssetRendererFactory.class, assetRendererFactory);
        _serviceRegistrations.put(assetRendererFactory, (Object)serviceRegistration);
    }

    public static void register(List<AssetRendererFactory<?>> assetRendererFactories) {
        for (AssetRendererFactory<?> assetRendererFactory : assetRendererFactories) {
            AssetRendererFactoryRegistryUtil.register(assetRendererFactory);
        }
    }

    public static void unregister(AssetRendererFactory<?> assetRendererFactory) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)_serviceRegistrations.remove(assetRendererFactory);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public static void unregister(List<AssetRendererFactory<?>> assetRendererFactories) {
        for (AssetRendererFactory<?> assetRendererFactory : assetRendererFactories) {
            AssetRendererFactoryRegistryUtil.unregister(assetRendererFactory);
        }
    }

    private static Map<String, AssetRendererFactory<?>> _filterAssetRendererFactories(long companyId, Map<String, AssetRendererFactory<?>> assetRendererFactories, boolean filterSelectable) {
        ConcurrentHashMap filteredAssetRendererFactories = new ConcurrentHashMap();
        for (Map.Entry<String, AssetRendererFactory<?>> entry : assetRendererFactories.entrySet()) {
            AssetRendererFactory<?> assetRendererFactory = entry.getValue();
            if (!assetRendererFactory.isActive(companyId) || filterSelectable && !assetRendererFactory.isSelectable()) continue;
            filteredAssetRendererFactories.put(entry.getKey(), assetRendererFactory);
        }
        return filteredAssetRendererFactories;
    }

    private AssetRendererFactoryRegistryUtil() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(AssetRendererFactory.class, (ServiceTrackerCustomizer)new AssetRendererFactoryServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class AssetRendererFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AssetRendererFactory<?>, AssetRendererFactory<?>> {
        private AssetRendererFactoryServiceTrackerCustomizer() {
        }

        public AssetRendererFactory<?> addingService(ServiceReference<AssetRendererFactory<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AssetRendererFactory assetRendererFactory = (AssetRendererFactory)registry.getService(serviceReference);
            String className = assetRendererFactory.getClassName();
            AssetRendererFactory classNameAssetRendererFactory = _assetRenderFactoriesMapByClassName.put(className, assetRendererFactory);
            if (_log.isWarnEnabled() && classNameAssetRendererFactory != null) {
                _log.warn(StringBundler.concat("Replacing ", String.valueOf(classNameAssetRendererFactory), " for class name ", className, " with ", String.valueOf(assetRendererFactory)));
            }
            String type = assetRendererFactory.getType();
            AssetRendererFactory typeAssetRendererFactory = _assetRenderFactoriesMapByClassType.put(type, assetRendererFactory);
            if (_log.isWarnEnabled() && typeAssetRendererFactory != null) {
                _log.warn(StringBundler.concat("Replacing ", String.valueOf(typeAssetRendererFactory), " for type ", type, " with ", String.valueOf(assetRendererFactory)));
            }
            return assetRendererFactory;
        }

        public void modifiedService(ServiceReference<AssetRendererFactory<?>> serviceReference, AssetRendererFactory<?> assetRendererFactory) {
        }

        public void removedService(ServiceReference<AssetRendererFactory<?>> serviceReference, AssetRendererFactory<?> assetRendererFactory) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _assetRenderFactoriesMapByClassName.remove(assetRendererFactory.getClassName());
            _assetRenderFactoriesMapByClassType.remove(assetRendererFactory.getType());
        }
    }
}

