/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.util.ProxyFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicPortalCache<K extends Serializable, V>
implements PortalCache<K, V> {
    private static final PortalCache<? extends Serializable, ?> _DUMMY_PORTAL_CACHE = ProxyFactory.newDummyInstance(PortalCache.class);
    private final boolean _blocking;
    private final boolean _mvcc;
    private volatile PortalCache<K, V> _portalCache;
    private final Map<PortalCacheListener<K, V>, PortalCacheListenerScope> _portalCacheListeners = new ConcurrentHashMap<PortalCacheListener<K, V>, PortalCacheListenerScope>();
    private final PortalCacheManager<K, V> _portalCacheManager;
    private final String _portalCacheName;

    public DynamicPortalCache(PortalCacheManager<K, V> portalCacheManager, PortalCache<K, V> portalCache, String portalCacheName, boolean blocking, boolean mvcc) {
        this._portalCacheManager = portalCacheManager;
        this._portalCacheName = portalCacheName;
        this._blocking = blocking;
        this._mvcc = mvcc;
        if (portalCache == null) {
            portalCache = _DUMMY_PORTAL_CACHE;
        }
        this._portalCache = portalCache;
    }

    @Override
    public V get(K key) {
        return this._portalCache.get(key);
    }

    @Override
    public List<K> getKeys() {
        List<K> keys = this._portalCache.getKeys();
        if (keys == null) {
            return Collections.emptyList();
        }
        return keys;
    }

    @Override
    public PortalCacheManager<K, V> getPortalCacheManager() {
        return this._portalCacheManager;
    }

    @Override
    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    @Override
    public boolean isBlocking() {
        return this._blocking;
    }

    @Override
    public boolean isMVCC() {
        return this._mvcc;
    }

    @Override
    public void put(K key, V value) {
        this._portalCache.put(key, value);
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        this._portalCache.put(key, value, timeToLive);
    }

    @Override
    public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
        this._portalCache.registerPortalCacheListener(portalCacheListener);
        this._portalCacheListeners.put(portalCacheListener, PortalCacheListenerScope.ALL);
    }

    @Override
    public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
        this._portalCache.registerPortalCacheListener(portalCacheListener, portalCacheListenerScope);
        this._portalCacheListeners.put(portalCacheListener, portalCacheListenerScope);
    }

    @Override
    public void remove(K key) {
        this._portalCache.remove(key);
    }

    @Override
    public void removeAll() {
        this._portalCache.removeAll();
    }

    @Override
    public void unregisterPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
        this._portalCache.unregisterPortalCacheListener(portalCacheListener);
        this._portalCacheListeners.remove(portalCacheListener);
    }

    @Override
    public void unregisterPortalCacheListeners() {
        this._portalCache.unregisterPortalCacheListeners();
        this._portalCacheListeners.clear();
    }

    protected void setPortalCache(PortalCache<K, V> portalCache) {
        if (this._portalCache == portalCache) {
            return;
        }
        if (portalCache == null) {
            portalCache = _DUMMY_PORTAL_CACHE;
        }
        this._portalCache = portalCache;
        for (Map.Entry<PortalCacheListener<K, V>, PortalCacheListenerScope> entry : this._portalCacheListeners.entrySet()) {
            portalCache.registerPortalCacheListener(entry.getKey(), entry.getValue());
        }
    }
}

