/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class RowChecker {
    public static final String ALIGN = "left";
    public static final String ALL_ROW_IDS = "allRowIds";
    public static final int COLSPAN = 1;
    public static final String CSS_CLASS = "";
    public static final String FORM_NAME = "fm";
    public static final String ROW_IDS = "rowIds";
    public static final String VALIGN = "middle";
    private String _align = "left";
    private String _allRowIds;
    private int _colspan = 1;
    private String _cssClass = "";
    private Map<String, Object> _data;
    private String _formName;
    private final PortletResponse _portletResponse;
    private boolean _rememberCheckBoxState = true;
    private String _rememberCheckBoxStateURLRegex;
    private String _rowIds;
    private String _rowSelector;
    private String _valign = "middle";

    public RowChecker(PortletResponse portletResponse) {
        this._portletResponse = portletResponse;
        this._allRowIds = this._portletResponse.getNamespace() + ALL_ROW_IDS;
        this._formName = this._portletResponse.getNamespace() + FORM_NAME;
        this._rowIds = this._portletResponse.getNamespace() + ROW_IDS;
    }

    public String getAlign() {
        return this._align;
    }

    public String getAllRowIds() {
        return this._allRowIds;
    }

    public String getAllRowsCheckBox() {
        return this.getAllRowsCheckBox(null);
    }

    public String getAllRowsCheckBox(HttpServletRequest httpServletRequest) {
        return this.getAllRowsCheckbox(httpServletRequest, this._allRowIds, StringUtil.quote(this._rowIds));
    }

    public String getAllRowsId() {
        return this.getAllRowIds();
    }

    public int getColspan() {
        return this._colspan;
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public Map<String, Object> getData(Object obj) {
        return this._data;
    }

    public String getFormName() {
        return this._formName;
    }

    public String getRememberCheckBoxStateURLRegex() {
        return this._rememberCheckBoxStateURLRegex;
    }

    public String getRowCheckBox(HttpServletRequest httpServletRequest, boolean checked, boolean disabled, String primaryKey) {
        return this.getRowCheckBox(httpServletRequest, checked, disabled, this._rowIds, primaryKey, StringUtil.quote(this._rowIds), StringUtil.quote(this._allRowIds), CSS_CLASS);
    }

    public String getRowId() {
        return this.getRowIds();
    }

    public String getRowIds() {
        return this._rowIds;
    }

    public String getRowSelector() {
        return this._rowSelector;
    }

    public String getValign() {
        return this._valign;
    }

    public boolean isChecked(Object obj) {
        return false;
    }

    public boolean isDisabled(Object obj) {
        return false;
    }

    public boolean isRememberCheckBoxState() {
        return this._rememberCheckBoxState;
    }

    public void setAlign(String align) {
        this._align = align;
    }

    public void setAllRowIds(String allRowIds) {
        this._allRowIds = this.getNamespacedValue(allRowIds);
    }

    public void setColspan(int colspan) {
        this._colspan = colspan;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setData(Map<String, Object> data) {
        this._data = data;
    }

    public void setFormName(String formName) {
        this._formName = this.getNamespacedValue(formName);
    }

    public void setRememberCheckBoxState(boolean rememberCheckBoxState) {
        this._rememberCheckBoxState = rememberCheckBoxState;
    }

    public void setRememberCheckBoxStateURLRegex(String rememberCheckBoxStateURLRegex) {
        this._rememberCheckBoxStateURLRegex = rememberCheckBoxStateURLRegex;
    }

    public void setRowIds(String rowIds) {
        this._rowIds = this.getNamespacedValue(rowIds);
    }

    public void setRowSelector(String rowSelector) {
        this._rowSelector = this.getNamespacedValue(rowSelector);
    }

    public void setValign(String valign) {
        this._valign = valign;
    }

    protected String getAllRowsCheckbox(HttpServletRequest httpServletRequest, String name, String checkBoxRowIds) {
        if (Validator.isNull(name)) {
            return CSS_CLASS;
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append("<label><input name=\"");
        sb.append(name);
        sb.append("\" title=\"");
        sb.append(LanguageUtil.get(this.getLocale(httpServletRequest), "select-all"));
        sb.append("\" type=\"checkbox\" ");
        sb.append(HtmlUtil.buildData(this._data));
        sb.append("onClick=\"Liferay.Util.checkAll(AUI().one(this).ancestor(");
        sb.append("'.table'), ");
        sb.append(checkBoxRowIds);
        sb.append(", this, 'tr:not(.lfr-template)');\"></label>");
        return sb.toString();
    }

    protected Locale getLocale(HttpServletRequest httpServletRequest) {
        Locale locale = null;
        if (httpServletRequest != null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            locale = themeDisplay.getLocale();
        } else {
            locale = LocaleThreadLocal.getThemeDisplayLocale();
        }
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }

    protected String getNamespacedValue(String value) {
        if (Validator.isNull(value)) {
            return CSS_CLASS;
        }
        if (!value.startsWith(this._portletResponse.getNamespace())) {
            value = this._portletResponse.getNamespace() + value;
        }
        return value;
    }

    protected String getOnClick(String checkBoxRowIds, String checkBoxAllRowIds, String checkBoxPostOnClick) {
        StringBundler sb = new StringBundler(9);
        sb.append("onClick=\"Liferay.Util.rowCheckerCheckAllBox(AUI().");
        sb.append("one(this).ancestor('.table'), AUI().one(this).");
        sb.append("ancestor('tr:not(.lfr-template)'), ");
        sb.append(checkBoxRowIds);
        sb.append(", ");
        sb.append(checkBoxAllRowIds);
        sb.append(", 'info');");
        if (Validator.isNotNull(checkBoxPostOnClick)) {
            sb.append(checkBoxPostOnClick);
        }
        sb.append("\"");
        return sb.toString();
    }

    protected String getRowCheckBox(HttpServletRequest httpServletRequest, boolean checked, boolean disabled, String name, String value, String checkBoxRowIds, String checkBoxAllRowIds, String checkBoxPostOnClick) {
        StringBundler sb = new StringBundler(14);
        sb.append("<label><input ");
        if (checked) {
            sb.append("checked ");
        }
        if (disabled) {
            sb.append("disabled ");
        }
        sb.append("class=\"");
        sb.append(this._cssClass);
        sb.append("\" name=\"");
        sb.append(name);
        sb.append("\" title=\"");
        sb.append(LanguageUtil.get(httpServletRequest.getLocale(), "select"));
        sb.append("\" type=\"checkbox\" value=\"");
        sb.append(HtmlUtil.escapeAttribute(value));
        sb.append("\" ");
        if (Validator.isNotNull(this._allRowIds)) {
            sb.append(this.getOnClick(checkBoxRowIds, checkBoxAllRowIds, checkBoxPostOnClick));
        }
        sb.append("></label>");
        return sb.toString();
    }
}

