/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.nonblocking;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.BaseIntraband;
import com.liferay.portal.kernel.nio.intraband.ChannelContext;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.nonblocking.SelectionKeyRegistrationReference;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;

public class SelectorIntraband
extends BaseIntraband {
    protected static final ThreadFactory threadFactory = new NamedThreadFactory(SelectorIntraband.class + ".threadFactory", 5, SelectorIntraband.class.getClassLoader());
    protected final Thread pollingThread = threadFactory.newThread(new PollingJob());
    protected final Queue<FutureTask<RegistrationReference>> registerQueue = new ConcurrentLinkedQueue<FutureTask<RegistrationReference>>();
    protected final Selector selector = Selector.open();
    private static final Log _log = LogFactoryUtil.getLog(SelectorIntraband.class);

    public SelectorIntraband(long defaultTimeout) throws IOException {
        super(defaultTimeout);
        this.pollingThread.start();
    }

    @Override
    public void close() throws InterruptedException, IOException {
        this.selector.close();
        this.pollingThread.interrupt();
        this.pollingThread.join(this.defaultTimeout);
        super.close();
    }

    @Override
    public RegistrationReference registerChannel(Channel channel) throws IOException {
        if (channel == null) {
            throw new NullPointerException("Channel is null");
        }
        if (!(channel instanceof GatheringByteChannel)) {
            throw new IllegalArgumentException("Channel is not of type GatheringByteChannel");
        }
        if (!(channel instanceof ScatteringByteChannel)) {
            throw new IllegalArgumentException("Channel is not of type ScatteringByteChannel");
        }
        if (!(channel instanceof SelectableChannel)) {
            throw new IllegalArgumentException("Channel is not of type SelectableChannel");
        }
        SelectableChannel selectableChannel = (SelectableChannel)channel;
        if ((selectableChannel.validOps() & 1) == 0) {
            throw new IllegalArgumentException("Channel is not valid for reading");
        }
        if ((selectableChannel.validOps() & 4) == 0) {
            throw new IllegalArgumentException("Channel is not valid for writing");
        }
        this.ensureOpen();
        selectableChannel.configureBlocking(false);
        FutureTask<RegistrationReference> registerFutureTask = new FutureTask<RegistrationReference>(new RegisterCallable(selectableChannel, selectableChannel));
        this.registerQueue.offer(registerFutureTask);
        this.selector.wakeup();
        try {
            return registerFutureTask.get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public RegistrationReference registerChannel(ScatteringByteChannel scatteringByteChannel, GatheringByteChannel gatheringByteChannel) throws IOException {
        if (scatteringByteChannel == null) {
            throw new NullPointerException("Scattering byte channel is null");
        }
        if (gatheringByteChannel == null) {
            throw new NullPointerException("Gathering byte channel is null");
        }
        if (!(scatteringByteChannel instanceof SelectableChannel)) {
            throw new IllegalArgumentException("Scattering byte channel is not of type SelectableChannel");
        }
        if (!(gatheringByteChannel instanceof SelectableChannel)) {
            throw new IllegalArgumentException("Gathering byte channel is not of type SelectableChannel");
        }
        SelectableChannel readSelectableChannel = (SelectableChannel)((Object)scatteringByteChannel);
        if ((readSelectableChannel.validOps() & 1) == 0) {
            throw new IllegalArgumentException("Scattering byte channel is not valid for reading");
        }
        SelectableChannel writeSelectableChannel = (SelectableChannel)((Object)gatheringByteChannel);
        if ((writeSelectableChannel.validOps() & 4) == 0) {
            throw new IllegalArgumentException("Gathering byte channel is not valid for writing");
        }
        this.ensureOpen();
        readSelectableChannel.configureBlocking(false);
        writeSelectableChannel.configureBlocking(false);
        FutureTask<RegistrationReference> registerFutureTask = new FutureTask<RegistrationReference>(new RegisterCallable(readSelectableChannel, writeSelectableChannel));
        this.registerQueue.offer(registerFutureTask);
        this.selector.wakeup();
        try {
            return registerFutureTask.get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSendDatagram(RegistrationReference registrationReference, Datagram datagram) {
        SelectionKeyRegistrationReference selectionKeyRegistrationReference = (SelectionKeyRegistrationReference)registrationReference;
        SelectionKey writeSelectionKey = selectionKeyRegistrationReference.writeSelectionKey;
        ChannelContext channelContext = (ChannelContext)writeSelectionKey.attachment();
        Queue<Datagram> sendingQueue = channelContext.getSendingQueue();
        sendingQueue.offer(datagram);
        SelectionKey selectionKey = writeSelectionKey;
        synchronized (selectionKey) {
            int ops = writeSelectionKey.interestOps();
            if ((ops & 4) == 0) {
                writeSelectionKey.interestOps(ops |= 4);
                this.selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerChannels() {
        FutureTask<RegistrationReference> registerFuturetask = null;
        Selector selector = this.selector;
        synchronized (selector) {
            while ((registerFuturetask = this.registerQueue.poll()) != null) {
                registerFuturetask.run();
            }
        }
    }

    private void _processReading(SelectionKey selectionKey) {
        ScatteringByteChannel scatteringByteChannel = (ScatteringByteChannel)((Object)selectionKey.channel());
        ChannelContext channelContext = (ChannelContext)selectionKey.attachment();
        this.handleReading(scatteringByteChannel, channelContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processWriting(SelectionKey selectionKey) {
        GatheringByteChannel gatheringByteChannel = (GatheringByteChannel)((Object)selectionKey.channel());
        ChannelContext channelContext = (ChannelContext)selectionKey.attachment();
        Queue<Datagram> sendingQueue = channelContext.getSendingQueue();
        if (channelContext.getWritingDatagram() == null) {
            channelContext.setWritingDatagram(sendingQueue.poll());
        }
        boolean backOff = false;
        if (channelContext.getWritingDatagram() != null) {
            if (this.handleWriting(gatheringByteChannel, channelContext) && sendingQueue.isEmpty()) {
                backOff = true;
            }
        } else {
            backOff = true;
        }
        if (backOff) {
            int ops = selectionKey.interestOps();
            ops &= 0xFFFFFFFB;
            SelectionKey selectionKey2 = selectionKey;
            synchronized (selectionKey2) {
                if (sendingQueue.isEmpty()) {
                    selectionKey.interestOps(ops);
                }
            }
        }
    }

    private class PollingJob
    implements Runnable {
        private PollingJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        int readyCount;
                        if ((readyCount = SelectorIntraband.this.selector.select()) > 0) {
                            Set<SelectionKey> selectionKeys = SelectorIntraband.this.selector.selectedKeys();
                            Iterator<SelectionKey> iterator = selectionKeys.iterator();
                            while (iterator.hasNext()) {
                                SelectionKey selectionKey = iterator.next();
                                iterator.remove();
                                try {
                                    if (selectionKey.isReadable()) {
                                        SelectorIntraband.this._processReading(selectionKey);
                                    }
                                    if (!selectionKey.isWritable()) continue;
                                    SelectorIntraband.this._processWriting(selectionKey);
                                }
                                catch (CancelledKeyException cancelledKeyException) {}
                            }
                        } else if (!SelectorIntraband.this.selector.isOpen()) {
                            break;
                        }
                        SelectorIntraband.this.registerChannels();
                        SelectorIntraband.this.cleanUpTimeoutResponseWaitingDatagrams();
                    }
                }
                finally {
                    SelectorIntraband.this.selector.close();
                }
            }
            catch (ClosedSelectorException cse) {
                if (_log.isInfoEnabled()) {
                    Thread currentThread = Thread.currentThread();
                    _log.info(currentThread.getName() + " exiting gracefully on selector closure");
                }
            }
            catch (Throwable t) {
                Thread currentThread = Thread.currentThread();
                _log.error(currentThread.getName() + " exiting exceptionally", t);
            }
            SelectorIntraband.this.registerChannels();
            SelectorIntraband.this.responseWaitingMap.clear();
            SelectorIntraband.this.timeoutMap.clear();
        }
    }

    protected class RegisterCallable
    implements Callable<RegistrationReference> {
        private final SelectableChannel _readSelectableChannel;
        private final SelectableChannel _writeSelectableChannel;

        public RegisterCallable(SelectableChannel readSelectableChannel, SelectableChannel writeSelectableChannel) {
            this._readSelectableChannel = readSelectableChannel;
            this._writeSelectableChannel = writeSelectableChannel;
        }

        @Override
        public RegistrationReference call() throws Exception {
            if (this._readSelectableChannel == this._writeSelectableChannel) {
                SelectionKey selectionKey = this._readSelectableChannel.register(SelectorIntraband.this.selector, 0);
                SelectionKeyRegistrationReference selectionKeyRegistrationReference = new SelectionKeyRegistrationReference(SelectorIntraband.this, selectionKey, selectionKey);
                ChannelContext channelContext = new ChannelContext(new ConcurrentLinkedQueue<Datagram>());
                channelContext.setRegistrationReference(selectionKeyRegistrationReference);
                selectionKey.attach(channelContext);
                selectionKey.interestOps(1);
                return selectionKeyRegistrationReference;
            }
            SelectionKey readSelectionKey = this._readSelectableChannel.register(SelectorIntraband.this.selector, 0);
            SelectionKey writeSelectionKey = this._writeSelectableChannel.register(SelectorIntraband.this.selector, 0);
            SelectionKeyRegistrationReference selectionKeyRegistrationReference = new SelectionKeyRegistrationReference(SelectorIntraband.this, readSelectionKey, writeSelectionKey);
            ChannelContext channelContext = new ChannelContext(new ConcurrentLinkedQueue<Datagram>());
            channelContext.setRegistrationReference(selectionKeyRegistrationReference);
            readSelectionKey.attach(channelContext);
            writeSelectionKey.attach(channelContext);
            readSelectionKey.interestOps(1);
            return selectionKeyRegistrationReference;
        }
    }
}

