/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.provider;

import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.welder.Welder;
import com.liferay.portal.kernel.process.ProcessChannel;
import com.liferay.portal.kernel.process.ProcessConfig;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.provider.SPIProvider;
import com.liferay.portal.kernel.resiliency.spi.provider.SPISynchronousQueueUtil;
import com.liferay.portal.kernel.resiliency.spi.remote.RemoteSPI;
import com.liferay.portal.kernel.resiliency.spi.remote.RemoteSPIProxy;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public abstract class BaseSPIProvider
implements SPIProvider {
    private static volatile ProcessExecutor _processExecutor = ServiceProxyFactory.newServiceTrackedInstance(ProcessExecutor.class, BaseSPIProvider.class, "_processExecutor", true);

    public abstract RemoteSPI createRemoteSPI(SPIConfiguration var1) throws PortalResiliencyException;

    @Override
    public SPI createSPI(SPIConfiguration spiConfiguration) throws PortalResiliencyException {
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        builder.setArguments(spiConfiguration.getJVMArguments());
        builder.setBootstrapClassPath(this.getClassPath());
        builder.setJavaExecutable(spiConfiguration.getJavaExecutable());
        builder.setReactClassLoader(PortalClassLoaderUtil.getClassLoader());
        builder.setRuntimeClassPath(this.getClassPath());
        RemoteSPI remoteSPI = this.createRemoteSPI(spiConfiguration);
        String spiUUID = remoteSPI.getUUID();
        SynchronousQueue<SPI> synchronousQueue = SPISynchronousQueueUtil.createSynchronousQueue(spiUUID);
        FutureTask<RegistrationReference> weldServerFutureTask = new FutureTask<RegistrationReference>(new WeldServerCallable(remoteSPI.getWelder()));
        Thread weldServerThread = new Thread(weldServerFutureTask, "Weld Server Thread for " + spiConfiguration.getSPIId());
        weldServerThread.setDaemon(true);
        weldServerThread.start();
        try {
            ProcessChannel<SPI> processChannel = _processExecutor.execute(builder.build(), remoteSPI);
            NoticeableFuture<SPI> cancelHandlerFuture = processChannel.getProcessNoticeableFuture();
            SPI spi = synchronousQueue.poll(spiConfiguration.getRegisterTimeout(), TimeUnit.MILLISECONDS);
            if (spi != null) {
                RegistrationReference registrationReference = weldServerFutureTask.get(spiConfiguration.getRegisterTimeout(), TimeUnit.MILLISECONDS);
                RemoteSPIProxy remoteSPIProxy = new RemoteSPIProxy(spi, spiConfiguration, this.getName(), cancelHandlerFuture, registrationReference);
                if (!MPIHelperUtil.registerSPI(remoteSPIProxy)) {
                    cancelHandlerFuture.cancel(true);
                    throw new PortalResiliencyException("Unable to register SPI " + remoteSPIProxy + ". Forcibly cancelled SPI process launch.");
                }
                RemoteSPIProxy remoteSPIProxy2 = remoteSPIProxy;
                return remoteSPIProxy2;
            }
            try {
                cancelHandlerFuture.cancel(true);
                throw new PortalResiliencyException("SPI synchronous queue waiting timeout. Forcibly cancelled SPI process launch.");
            }
            catch (InterruptedException ie) {
                throw new PortalResiliencyException("Interrupted on waiting SPI process, registering back RMI stub", ie);
            }
            catch (PortalResiliencyException pre) {
                throw pre;
            }
            catch (Exception e) {
                throw new PortalResiliencyException("Unable to launch SPI process", e);
            }
        }
        finally {
            weldServerFutureTask.cancel(true);
            SPISynchronousQueueUtil.destroySynchronousQueue(spiUUID);
        }
    }

    public abstract String getClassPath();

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{name=");
        sb.append(this.getName());
        sb.append(", classPath=");
        sb.append(this.getClassPath());
        sb.append("}");
        return sb.toString();
    }

    protected static class WeldServerCallable
    implements Callable<RegistrationReference> {
        private final Welder _welder;

        public WeldServerCallable(Welder welder) {
            this._welder = welder;
        }

        @Override
        public RegistrationReference call() throws Exception {
            return this._welder.weld(MPIHelperUtil.getIntraband());
        }
    }
}

