/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.generic;

import com.liferay.portal.kernel.search.BaseQueryImpl;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.kernel.util.StringBundler;

public class TermRangeQueryImpl
extends BaseQueryImpl
implements TermRangeQuery {
    private final String _field;
    private final boolean _includesLower;
    private final boolean _includesUpper;
    private final String _lowerTerm;
    private final String _upperTerm;

    public TermRangeQueryImpl(String field, String lowerTerm, String upperTerm, boolean includesLower, boolean includesUpper) {
        this._field = field;
        this._lowerTerm = lowerTerm;
        this._upperTerm = upperTerm;
        this._includesLower = includesLower;
        this._includesUpper = includesUpper;
    }

    @Override
    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return queryVisitor.visitQuery(this);
    }

    @Override
    public String getField() {
        return this._field;
    }

    @Override
    public String getLowerTerm() {
        return this._lowerTerm;
    }

    @Override
    public String getUpperTerm() {
        return this._upperTerm;
    }

    @Override
    public boolean includesLower() {
        return this._includesLower;
    }

    @Override
    public boolean includesUpper() {
        return this._includesUpper;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", field=");
        sb.append(this._field);
        sb.append(", range=");
        if (this._includesLower) {
            sb.append('[');
        } else {
            sb.append('{');
        }
        if (this._lowerTerm != null) {
            sb.append(this._lowerTerm);
        } else {
            sb.append('*');
        }
        sb.append(" TO ");
        if (this._upperTerm != null) {
            sb.append(this._upperTerm);
        } else {
            sb.append('*');
        }
        if (this._includesUpper) {
            sb.append(']');
        } else {
            sb.append('}');
        }
        sb.append("}");
        return sb.toString();
    }
}

