/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Arrays;

public class TransactionConfig {
    private final Isolation _isolation;
    private final Class<?>[] _noRollbackForClasses;
    private final String[] _noRollbackForClassNames;
    private final Propagation _propagation;
    private final boolean _readOnly;
    private final Class<?>[] _rollbackForClasses;
    private final String[] _rollbackForClassNames;
    private final int _timeout;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransactionConfig)) {
            return false;
        }
        TransactionConfig transactionConfig = (TransactionConfig)obj;
        return this._isolation == transactionConfig._isolation && Arrays.equals(this._noRollbackForClassNames, transactionConfig._noRollbackForClassNames) && Arrays.equals(this._noRollbackForClasses, transactionConfig._noRollbackForClasses) && this._propagation == transactionConfig._propagation && this._readOnly == transactionConfig._readOnly && Arrays.equals(this._rollbackForClassNames, transactionConfig._rollbackForClassNames) && Arrays.equals(this._rollbackForClasses, transactionConfig._rollbackForClasses) && this._timeout == transactionConfig._timeout;
    }

    public Isolation getIsolation() {
        return this._isolation;
    }

    public Class<?>[] getNoRollbackForClasses() {
        return this._noRollbackForClasses;
    }

    public String[] getNoRollbackForClassNames() {
        return this._noRollbackForClassNames;
    }

    public Propagation getPropagation() {
        return this._propagation;
    }

    public Class<?>[] getRollbackForClasses() {
        return this._rollbackForClasses;
    }

    public String[] getRollbackForClassNames() {
        return this._rollbackForClassNames;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)((Object)this._isolation));
        if (this._noRollbackForClassNames == null) {
            hash = HashUtil.hash((int)hash, (int)0);
        } else {
            for (String noRollbackForClassName : this._noRollbackForClassNames) {
                hash = HashUtil.hash((int)hash, (Object)noRollbackForClassName);
            }
        }
        if (this._noRollbackForClasses == null) {
            hash = HashUtil.hash((int)hash, (int)0);
        } else {
            for (Class<?> noRollbackForClass : this._noRollbackForClasses) {
                hash = HashUtil.hash((int)hash, (Object)noRollbackForClass);
            }
        }
        hash = HashUtil.hash((int)hash, (Object)((Object)this._propagation));
        hash = HashUtil.hash((int)hash, (boolean)this._readOnly);
        if (this._rollbackForClassNames == null) {
            hash = HashUtil.hash((int)hash, (int)0);
        } else {
            for (String rollbackForClassName : this._rollbackForClassNames) {
                hash = HashUtil.hash((int)hash, (Object)rollbackForClassName);
            }
        }
        if (this._rollbackForClasses == null) {
            hash = HashUtil.hash((int)hash, (int)0);
        } else {
            for (Class<?> rollbackForClass : this._rollbackForClasses) {
                hash = HashUtil.hash((int)hash, (Object)rollbackForClass);
            }
        }
        hash = HashUtil.hash((int)hash, (int)this._timeout);
        return hash;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public String toString() {
        StringBundler sb = new StringBundler(17);
        sb.append("{isolation=");
        sb.append((Object)this._isolation);
        sb.append(", noRollbackForClassNames=");
        sb.append(Arrays.toString(this._noRollbackForClassNames));
        sb.append(", noRollbackForClasses=");
        sb.append(Arrays.toString(this._noRollbackForClasses));
        sb.append(", propagation=");
        sb.append((Object)this._propagation);
        sb.append(", readOnly=");
        sb.append(this._readOnly);
        sb.append(", rollbackForClassNames=");
        sb.append(Arrays.toString(this._rollbackForClassNames));
        sb.append(", rollbackForClasses=");
        sb.append(Arrays.toString(this._rollbackForClasses));
        sb.append(", timeout=");
        sb.append(this._timeout);
        sb.append("}");
        return sb.toString();
    }

    private TransactionConfig(Builder builder) {
        this._isolation = builder._isolation;
        this._noRollbackForClassNames = builder._noRollbackForClassNames;
        this._noRollbackForClasses = builder._noRollbackForClasses;
        this._propagation = builder._propagation;
        this._readOnly = builder._readOnly;
        this._rollbackForClassNames = builder._rollbackForClassNames;
        this._rollbackForClasses = builder._rollbackForClasses;
        this._timeout = builder._timeout;
    }

    public static class Factory {
        public static TransactionConfig create(Isolation isolation, Propagation propagation, boolean readOnly, int timeout, Class<?>[] rollbackForClasses, String[] rollbackForClassNames, Class<?>[] noRollbackForClasses, String[] noRollbackForClassNames) {
            Builder builder = new Builder();
            builder.setIsolation(isolation);
            builder.setPropagation(propagation);
            builder.setReadOnly(readOnly);
            builder.setTimeout(timeout);
            builder.setRollbackForClasses(rollbackForClasses);
            builder.setRollbackForClassNames(rollbackForClassNames);
            builder.setNoRollbackForClasses(noRollbackForClasses);
            builder.setNoRollbackForClassNames(noRollbackForClassNames);
            return builder.build();
        }

        public static TransactionConfig create(Propagation propagation, Class<?>[] rollbackForClasses, Class<?> ... noRollbackForClasses) {
            return Factory.create(Isolation.PORTAL, propagation, false, -1, rollbackForClasses, new String[0], noRollbackForClasses, new String[0]);
        }
    }

    public static class Builder {
        private static final Class<?>[] _EMPTY_CLASS_ARRAY = new Class[0];
        private Isolation _isolation = Isolation.DEFAULT;
        private Class<?>[] _noRollbackForClasses = _EMPTY_CLASS_ARRAY;
        private String[] _noRollbackForClassNames = StringPool.EMPTY_ARRAY;
        private Propagation _propagation = Propagation.REQUIRED;
        private boolean _readOnly;
        private Class<?>[] _rollbackForClasses = _EMPTY_CLASS_ARRAY;
        private String[] _rollbackForClassNames = StringPool.EMPTY_ARRAY;
        private int _timeout = -1;

        public TransactionConfig build() {
            return new TransactionConfig(this);
        }

        public Builder setIsolation(Isolation isolation) {
            this._isolation = isolation;
            return this;
        }

        public Builder setNoRollbackForClasses(Class<?> ... noRollbackForClasses) {
            this._noRollbackForClasses = noRollbackForClasses;
            return this;
        }

        public Builder setNoRollbackForClassNames(String ... noRollbackForClassNames) {
            this._noRollbackForClassNames = noRollbackForClassNames;
            return this;
        }

        public Builder setPropagation(Propagation propagation) {
            this._propagation = propagation;
            return this;
        }

        public Builder setReadOnly(boolean readOnly) {
            this._readOnly = readOnly;
            return this;
        }

        public Builder setRollbackForClasses(Class<?> ... rollbackForClasses) {
            this._rollbackForClasses = rollbackForClasses;
            return this;
        }

        public Builder setRollbackForClassNames(String ... rollbackForClassNames) {
            this._rollbackForClassNames = rollbackForClassNames;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this._timeout = timeout;
            return this;
        }
    }
}

