/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class BaseUpgradeCompanyId
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradeCompanyId.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpgrade() throws Exception {
        ArrayList<TableUpdater> callables = new ArrayList<TableUpdater>();
        for (TableUpdater tableUpdater : this.getTableUpdaters()) {
            if (!this.hasColumn(tableUpdater.getTableName(), "companyId")) {
                tableUpdater.setCreateCompanyIdColumn(true);
            }
            callables.add(tableUpdater);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(callables.size());
        try {
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    protected abstract TableUpdater[] getTableUpdaters();

    protected class TableUpdater
    implements Callable<Void> {
        private final String _columnName;
        private boolean _createCompanyIdColumn;
        private final String[][] _foreignNamesArray;
        private final String _tableName;

        public TableUpdater(String tableName, String foreignTableName, String foreignColumnName) {
            this._tableName = tableName;
            this._columnName = foreignColumnName;
            this._foreignNamesArray = new String[][]{{foreignTableName, foreignColumnName}};
        }

        public TableUpdater(String tableName, String columnName, String[][] foreignNamesArray) {
            this._tableName = tableName;
            this._columnName = columnName;
            this._foreignNamesArray = foreignNamesArray;
        }

        @Override
        public final Void call() throws Exception {
            try (LoggingTimer loggingTimer = new LoggingTimer(this._tableName);
                 Connection connection = DataAccess.getConnection();){
                if (this._createCompanyIdColumn) {
                    if (_log.isInfoEnabled()) {
                        _log.info("Adding column companyId to table " + this._tableName);
                    }
                    BaseUpgradeCompanyId.this.runSQL(connection, "alter table " + this._tableName + " add companyId LONG");
                } else if (_log.isInfoEnabled()) {
                    _log.info("Skipping the creation of companyId column for table " + this._tableName);
                }
                this.update(connection);
            }
            return null;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setCreateCompanyIdColumn(boolean createCompanyIdColumn) {
            this._createCompanyIdColumn = createCompanyIdColumn;
        }

        public void update(Connection connection) throws IOException, SQLException {
            for (String[] foreignNames : this._foreignNamesArray) {
                BaseUpgradeCompanyId.this.runSQL(connection, this.getUpdateSQL(connection, foreignNames[0], foreignNames[1]));
            }
        }

        protected List<Long> getCompanyIds(Connection connection) throws SQLException {
            ArrayList<Long> companyIds = new ArrayList<Long>();
            try (PreparedStatement ps = connection.prepareStatement("select companyId from Company");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong(1);
                    companyIds.add(companyId);
                }
            }
            return companyIds;
        }

        protected String getSelectSQL(Connection connection, String foreignTableName, String foreignColumnName) throws SQLException {
            List<Long> companyIds = this.getCompanyIds(connection);
            if (companyIds.size() == 1) {
                return String.valueOf(companyIds.get(0));
            }
            StringBundler sb = new StringBundler(10);
            sb.append("select max(companyId) from ");
            sb.append(foreignTableName);
            sb.append(" where ");
            sb.append(foreignTableName);
            sb.append(".");
            sb.append(foreignColumnName);
            sb.append(" = ");
            sb.append(this._tableName);
            sb.append(".");
            sb.append(this._columnName);
            return sb.toString();
        }

        protected String getUpdateSQL(Connection connection, String foreignTableName, String foreignColumnName) throws SQLException {
            return this.getUpdateSQL(this.getSelectSQL(connection, foreignTableName, foreignColumnName));
        }

        protected String getUpdateSQL(String selectSQL) {
            StringBundler sb = new StringBundler(5);
            sb.append("update ");
            sb.append(this._tableName);
            sb.append(" set companyId = (");
            sb.append(selectSQL);
            sb.append(")");
            return sb.toString();
        }
    }
}

