/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class BaseUpgradePortletPreferences
extends com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences {
    protected void deletePortletPreferencesByOwnerType(int ownerType, String whereClause, String leftColumnName, String[] ... joinTables) throws Exception {
        StringBundler sb = new StringBundler(9 * joinTables.length + 5);
        sb.append("delete from PortletPreferences where ownerType = ");
        sb.append(String.valueOf(ownerType));
        for (String[] joinTable : joinTables) {
            sb.append(" and not exists (select 1 from ");
            sb.append(joinTable[1]);
            sb.append(" where PortletPreferences.");
            sb.append(leftColumnName);
            sb.append(" = ");
            sb.append(joinTable[1]);
            sb.append(".");
            sb.append(joinTable[0]);
            sb.append(")");
        }
        if (Validator.isNotNull(whereClause)) {
            sb.append(" and (");
            sb.append(whereClause);
            sb.append(")");
        }
        this.runSQL(sb.toString());
    }

    @Override
    protected void updatePortletPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String whereClause = this.getUpdatePortletPreferencesWhereClause();
            this.deletePortletPreferencesByOwnerType(5, whereClause, "ownerId", new String[][]{{"portletItemId", "PortletItem"}});
            this.deletePortletPreferencesByOwnerType(1, whereClause, "ownerId", new String[][]{{"companyId", "Company"}});
            this.deletePortletPreferencesByOwnerType(2, whereClause, "ownerId", new String[][]{{"groupId", "Group_"}});
            this.deletePortletPreferencesByOwnerType(3, whereClause, "plid", {"plid", "Layout"}, {"layoutRevisionId", "LayoutRevision"});
            this.deletePortletPreferencesByOwnerType(6, whereClause, "ownerId", new String[][]{{"organizationId", "Organization_"}});
            this.deletePortletPreferencesByOwnerType(4, whereClause, "ownerId", new String[][]{{"userId", "User_"}});
            this.updatePortletPreferencesWithOwnerType(5, whereClause, "ownerId", "PortletItem", "portletItemId");
            this.updatePortletPreferencesWithOwnerType(1, whereClause, "ownerId", "Company", "companyId");
            this.updatePortletPreferencesWithOwnerType(2, whereClause, "ownerId", "Group_", "groupId");
            this.updatePortletPreferencesWithOwnerType(3, whereClause, "plid", "Layout", "plid");
            this.updatePortletPreferencesWithOwnerType(3, whereClause, "plid", "LayoutRevision", "layoutRevisionId");
            this.updatePortletPreferencesWithOwnerType(6, whereClause, "ownerId", "Organization_", "organizationId");
            this.updatePortletPreferencesWithOwnerType(4, whereClause, "ownerId", "User_", "userId");
        }
    }

    protected void updatePortletPreferencesWithOwnerType(int ownerType, String whereClause, String leftColumnName, String rightTableName, String rightColumnName) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(" where PortletPreferences.ownerType = ");
        sb.append(String.valueOf(ownerType));
        if (Validator.isNotNull(whereClause)) {
            sb.append(" and (");
            sb.append(whereClause);
            sb.append(")");
        }
        String sql = StringBundler.concat("select PortletPreferences.portletPreferencesId as ", "portletPreferencesId, PortletPreferences.ownerId as ownerId, ", "PortletPreferences.plid as plid, PortletPreferences.portletId as ", "portletId, PortletPreferences.preferences as preferences, ", rightTableName, ".companyId as companyId from PortletPreferences inner join ", rightTableName, " on PortletPreferences.", leftColumnName, " = ", rightTableName, ".", rightColumnName, sb.toString());
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement(sql);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "update PortletPreferences set preferences = ? where portletPreferencesId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String newPreferences;
                long companyId = rs.getLong("companyId");
                long ownerId = rs.getLong("ownerId");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = GetterUtil.getString(rs.getString("preferences"));
                if (preferences.equals(newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences))) continue;
                ps2.setString(1, newPreferences);
                ps2.setLong(2, rs.getLong("portletPreferencesId"));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

