/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AggregateOrderByComparator<T>
extends OrderByComparator<T> {
    private final List<OrderByComparator<T>> _orderByComparators;

    public AggregateOrderByComparator(List<OrderByComparator<T>> orderByComparators) {
        this._orderByComparators = new ArrayList<OrderByComparator<T>>(orderByComparators);
    }

    public AggregateOrderByComparator(OrderByComparator<T> ... orderByComparators) {
        this._orderByComparators = new ArrayList<OrderByComparator<T>>(Arrays.asList(orderByComparators));
    }

    @Override
    public int compare(T t1, T t2) {
        for (OrderByComparator<T> orderByComparators : this._orderByComparators) {
            int value = orderByComparators.compare(t1, t2);
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    @Override
    public String getOrderBy() {
        return StringUtil.merge(ListUtil.toList(this._orderByComparators, OrderByComparator::getOrderBy), ",");
    }

    @Override
    public Comparator<T> reversed() {
        return Collections.reverseOrder(this);
    }
}

