/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JobStateSerializeUtil {
    private static final String _EXCEPTIONS_FIELD = "exceptions";
    private static final String _EXCEPTIONS_MAX_SIZE_FIELD = "exceptionsMaxSize";
    private static final String _TRIGGER_DATES_FIELD = "triggerDates";
    private static final String _TRIGGER_STATE_FIELD = "triggerState";
    private static final String _VERSION_FIELD = "version";

    public static JobState deserialize(Map<String, Object> jobStateMap) {
        Object object = jobStateMap.get(_VERSION_FIELD);
        if (!(object instanceof Integer)) {
            throw new IllegalStateException("Unable to find JobState version number");
        }
        int version = (Integer)object;
        if (version == 1) {
            return JobStateSerializeUtil._deserialize_1(jobStateMap);
        }
        throw new IllegalStateException("Unable to deserialize field for job state with version " + version);
    }

    public static Map<String, Object> serialize(JobState jobState) {
        return JobStateSerializeUtil._serialize_1(jobState);
    }

    private static JobState _deserialize_1(Map<String, Object> jobStateMap) {
        TriggerState triggerState = null;
        String triggerStateString = (String)jobStateMap.get(_TRIGGER_STATE_FIELD);
        try {
            triggerState = TriggerState.valueOf(triggerStateString);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException("Invalid value " + triggerStateString, iae);
        }
        int exceptionsMaxSize = (Integer)jobStateMap.get(_EXCEPTIONS_MAX_SIZE_FIELD);
        Map triggerDates = (Map)jobStateMap.get(_TRIGGER_DATES_FIELD);
        JobState jobState = null;
        jobState = triggerDates != null ? new JobState(triggerState, exceptionsMaxSize, triggerDates) : new JobState(triggerState, exceptionsMaxSize);
        ArrayList exceptionsList = (ArrayList)jobStateMap.get(_EXCEPTIONS_FIELD);
        if (exceptionsList != null) {
            for (Object[] exceptions : exceptionsList) {
                jobState.addException((Exception)exceptions[0], (Date)exceptions[1]);
            }
        }
        return jobState;
    }

    private static Map<String, Object> _serialize_1(JobState jobState) {
        HashMap<String, Object> jobStateMap = new HashMap<String, Object>();
        ObjectValuePair<Exception, Date>[] exceptions = jobState.getExceptions();
        if (exceptions != null) {
            ArrayList<Object[]> exceptionsList = new ArrayList<Object[]>();
            for (ObjectValuePair<Exception, Date> exception : exceptions) {
                exceptionsList.add(new Object[]{exception.getKey(), exception.getValue()});
            }
            exceptionsList.trimToSize();
            jobStateMap.put(_EXCEPTIONS_FIELD, exceptionsList);
        }
        jobStateMap.put(_EXCEPTIONS_MAX_SIZE_FIELD, jobState.getExceptionsMaxSize());
        jobStateMap.put(_TRIGGER_DATES_FIELD, jobState.getTriggerDates());
        TriggerState triggerState = jobState.getTriggerState();
        jobStateMap.put(_TRIGGER_STATE_FIELD, triggerState.toString());
        jobStateMap.put(_VERSION_FIELD, 1);
        return jobStateMap;
    }
}

