/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.comment;

import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.function.Function;

public class CommentManagerUtil {
    private static volatile CommentManager _commentManager = ServiceProxyFactory.newServiceTrackedInstance(CommentManager.class, CommentManagerUtil.class, "_commentManager", false);

    public static long addComment(long userId, long groupId, String className, long classPK, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil._getCommentManager().addComment(userId, groupId, className, classPK, body, serviceContextFunction);
    }

    public static long addComment(long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil._getCommentManager().addComment(userId, groupId, className, classPK, userName, subject, body, serviceContextFunction);
    }

    public static long addComment(long userId, String className, long classPK, String userName, long parentCommentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil._getCommentManager().addComment(userId, className, classPK, userName, parentCommentId, subject, body, serviceContextFunction);
    }

    public static void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        CommentManagerUtil._getCommentManager().addDiscussion(userId, groupId, className, classPK, userName);
    }

    public static void deleteComment(long commentId) throws PortalException {
        CommentManagerUtil._getCommentManager().deleteComment(commentId);
    }

    public static void deleteDiscussion(String className, long classPK) throws PortalException {
        CommentManagerUtil._getCommentManager().deleteDiscussion(className, classPK);
    }

    public static void deleteGroupComments(long groupId) throws PortalException {
        CommentManagerUtil._getCommentManager().deleteGroupComments(groupId);
    }

    public static Comment fetchComment(long commentId) {
        return CommentManagerUtil._getCommentManager().fetchComment(commentId);
    }

    @Deprecated
    public static CommentManager getCommentManager() {
        return CommentManagerUtil._getCommentManager();
    }

    public static int getCommentsCount(String className, long classPK) {
        return CommentManagerUtil._getCommentManager().getCommentsCount(className, classPK);
    }

    public static Discussion getDiscussion(long userId, long groupId, String className, long classPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil._getCommentManager().getDiscussion(userId, groupId, className, classPK, serviceContextFunction);
    }

    public static DiscussionPermission getDiscussionPermission(PermissionChecker permissionChecker) {
        return CommentManagerUtil._getCommentManager().getDiscussionPermission(permissionChecker);
    }

    public static DiscussionStagingHandler getDiscussionStagingHandler() {
        return CommentManagerUtil._getCommentManager().getDiscussionStagingHandler();
    }

    public static boolean hasDiscussion(String className, long classPK) throws PortalException {
        return CommentManagerUtil._getCommentManager().hasDiscussion(className, classPK);
    }

    public static void moveDiscussionToTrash(String className, long classPK) {
        CommentManagerUtil._getCommentManager().moveDiscussionToTrash(className, classPK);
    }

    public static void restoreDiscussionFromTrash(String className, long classPK) {
        CommentManagerUtil._getCommentManager().restoreDiscussionFromTrash(className, classPK);
    }

    public static void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        CommentManagerUtil._getCommentManager().subscribeDiscussion(userId, groupId, className, classPK);
    }

    public static void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        CommentManagerUtil._getCommentManager().unsubscribeDiscussion(userId, className, classPK);
    }

    public static long updateComment(long userId, String className, long classPK, long commentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil._getCommentManager().updateComment(userId, className, classPK, commentId, subject, body, serviceContextFunction);
    }

    private static CommentManager _getCommentManager() {
        return _commentManager;
    }
}

