/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Date;
import java.util.List;

public class UserPasswordException
extends PortalException {
    private static String _getDictionaryWordsString(List<String> dictionaryWords) {
        if (dictionaryWords.size() <= 10) {
            return dictionaryWords.toString();
        }
        List<String> sampleDictionaryWords = dictionaryWords.subList(0, 10);
        return sampleDictionaryWords.toString() + " " + "...";
    }

    private UserPasswordException(String message) {
        super(message);
    }

    public static class MustNotContainDictionaryWords
    extends UserPasswordException {
        public final List<String> dictionaryWords;
        public long userId;

        public MustNotContainDictionaryWords(long userId, List<String> dictionaryWords) {
            super(String.format("Password for user %s must not contain dictionary words such as: %s", userId, UserPasswordException._getDictionaryWordsString(dictionaryWords)));
            this.userId = userId;
            this.dictionaryWords = dictionaryWords;
        }
    }

    public static class MustNotBeTrivial
    extends UserPasswordException {
        public long userId;

        public MustNotBeTrivial(long userId) {
            super(String.format("Password for user %s must not be too trivial", userId));
            this.userId = userId;
        }
    }

    public static class MustNotBeRecentlyUsed
    extends UserPasswordException {
        public long userId;

        public MustNotBeRecentlyUsed(long userId) {
            super(String.format("Password for user %s was used too recently", userId));
            this.userId = userId;
        }
    }

    public static class MustNotBeNull
    extends UserPasswordException {
        public long userId;

        public MustNotBeNull(long userId) {
            super(String.format("Password for user %s must not be null", userId));
            this.userId = userId;
        }
    }

    public static class MustNotBeEqualToCurrent
    extends UserPasswordException {
        public final long userId;

        public MustNotBeEqualToCurrent(long userId) {
            super(String.format("Password for user %s must not be equal to their current password", userId));
            this.userId = userId;
        }
    }

    public static class MustNotBeChangedYet
    extends UserPasswordException {
        public final Date changeableDate;
        public long userId;

        public MustNotBeChangedYet(long userId, Date changeableDate) {
            super(String.format("Password for user %s must not be changed until %s", userId, changeableDate));
            this.userId = userId;
            this.changeableDate = changeableDate;
        }
    }

    public static class MustNotBeChanged
    extends UserPasswordException {
        public final long userId;

        public MustNotBeChanged(long userId) {
            super(String.format("Password for user %s must not be changed under the current password policy", userId));
            this.userId = userId;
        }
    }

    public static class MustMatchCurrentPassword
    extends UserPasswordException {
        public final long userId;

        public MustMatchCurrentPassword(long userId) {
            super(String.format("Password for user %s does not match the current password", userId));
            this.userId = userId;
        }
    }

    public static class MustMatch
    extends UserPasswordException {
        public final long userId;

        public MustMatch(long userId) {
            super(String.format("Passwords for user %s must match", userId));
            this.userId = userId;
        }
    }

    public static class MustHaveMoreUppercase
    extends UserPasswordException {
        public final long minUppercase;

        public MustHaveMoreUppercase(long minUppercase) {
            super(String.format("Password must have at least %s uppercase characters", minUppercase));
            this.minUppercase = minUppercase;
        }
    }

    public static class MustHaveMoreSymbols
    extends UserPasswordException {
        public final long minSymbols;

        public MustHaveMoreSymbols(long minSymbols) {
            super(String.format("Password must have at least %s symbols", minSymbols));
            this.minSymbols = minSymbols;
        }
    }

    public static class MustHaveMoreNumbers
    extends UserPasswordException {
        public final long minNumbers;

        public MustHaveMoreNumbers(long minNumbers) {
            super(String.format("Password must have at least %s numbers", minNumbers));
            this.minNumbers = minNumbers;
        }
    }

    public static class MustHaveMoreLowercase
    extends UserPasswordException {
        public final long minLowercase;

        public MustHaveMoreLowercase(long minLowercase) {
            super(String.format("Password must have at least %s lowercase characters", minLowercase));
            this.minLowercase = minLowercase;
        }
    }

    public static class MustHaveMoreAlphanumeric
    extends UserPasswordException {
        public final long minAlphanumeric;

        public MustHaveMoreAlphanumeric(long minAlphanumeric) {
            super(String.format("Password must have at least %s alphanumeric characters", minAlphanumeric));
            this.minAlphanumeric = minAlphanumeric;
        }
    }

    public static class MustComplyWithRegex
    extends UserPasswordException {
        public final String regex;
        public final long userId;

        public MustComplyWithRegex(long userId, String regex) {
            super(String.format("Password must comply with regex: " + regex, new Object[0]));
            this.regex = regex;
            this.userId = userId;
        }
    }

    public static class MustComplyWithModelListeners
    extends UserPasswordException {
        public final ModelListenerException modelListenerException;
        public final long userId;

        public MustComplyWithModelListeners(long userId, ModelListenerException modelListenerException) {
            super(String.format("Password must comply with model listeners: " + modelListenerException.getMessage(), new Object[0]));
            this.userId = userId;
            this.modelListenerException = modelListenerException;
        }
    }

    public static class MustBeLonger
    extends UserPasswordException {
        public final int minLength;
        public final long userId;

        public MustBeLonger(long userId, int minLength) {
            super(String.format("Password for user %s must be at least %s characters", userId, minLength));
            this.minLength = minLength;
            this.userId = userId;
        }
    }
}

