/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.local;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.local.ResultProcessCallable;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class LocalProcessLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) throws IOException {
        PrintStream oldOutPrintStream = System.out;
        ObjectOutputStream objectOutputStream = null;
        ProcessOutputStream outProcessOutputStream = null;
        PrintStream printStream = oldOutPrintStream;
        synchronized (printStream) {
            oldOutPrintStream.flush();
            FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
            objectOutputStream = new ObjectOutputStream(new UnsyncBufferedOutputStream(fileOutputStream));
            outProcessOutputStream = new ProcessOutputStream(objectOutputStream, false);
            ProcessContext._setProcessOutputStream(outProcessOutputStream);
            PrintStream newOutPrintStream = new PrintStream((OutputStream)outProcessOutputStream, true, "UTF-8");
            System.setOut(newOutPrintStream);
        }
        ProcessOutputStream errProcessOutputStream = new ProcessOutputStream(objectOutputStream, true);
        PrintStream errPrintStream = new PrintStream((OutputStream)errProcessOutputStream, true, "UTF-8");
        System.setErr(errPrintStream);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ObjectInputStream bootstrapObjectInputStream = new ObjectInputStream(System.in);
            String processCallableName = (String)bootstrapObjectInputStream.readObject();
            String logPrefixString = "[".concat(processCallableName).concat("]");
            byte[] logPrefix = logPrefixString.getBytes("UTF-8");
            outProcessOutputStream.setLogPrefix(logPrefix);
            errProcessOutputStream.setLogPrefix(logPrefix);
            String classPath = (String)bootstrapObjectInputStream.readObject();
            URLClassLoader classLoader = new URLClassLoader(LocalProcessLauncher._getClassPathURLs(classPath));
            currentThread.setContextClassLoader(classLoader);
            ClassLoaderObjectInputStream objectInputStream = new ClassLoaderObjectInputStream(bootstrapObjectInputStream, classLoader);
            ProcessCallable processCallable = (ProcessCallable)objectInputStream.readObject();
            Thread thread = new Thread((Runnable)new ProcessCallableDispatcher(objectInputStream), "ProcessCallable-Dispatcher");
            thread.setDaemon(true);
            thread.start();
            Object result = processCallable.call();
            System.out.flush();
            outProcessOutputStream.writeProcessCallable(new ResultProcessCallable(result, null));
            outProcessOutputStream.flush();
        }
        catch (Throwable t) {
            errPrintStream.flush();
            ProcessException processException = null;
            processException = t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
            errProcessOutputStream.writeProcessCallable(new ResultProcessCallable<Object>(null, processException));
            errProcessOutputStream.flush();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private static URL[] _getClassPathURLs(String classPath) throws MalformedURLException {
        String[] paths;
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String path : paths = StringUtil.split(classPath, File.pathSeparatorChar)) {
            File file = new File(path);
            URI uri = file.toURI();
            urls.add(uri.toURL());
        }
        return urls.toArray(new URL[0]);
    }

    private static class ProcessOutputStream
    extends UnsyncByteArrayOutputStream {
        private final boolean _error;
        private byte[] _logPrefix;
        private final ObjectOutputStream _objectOutputStream;

        @Override
        public void close() throws IOException {
            this._objectOutputStream.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                if (this.index > 0) {
                    byte[] bytes = this.toByteArray();
                    this.reset();
                    byte[] logData = new byte[this._logPrefix.length + bytes.length];
                    System.arraycopy(this._logPrefix, 0, logData, 0, this._logPrefix.length);
                    System.arraycopy(bytes, 0, logData, this._logPrefix.length, bytes.length);
                    String message = new String(bytes, "UTF-8");
                    this._objectOutputStream.writeObject(new LoggingProcessCallable(message, this._error));
                }
                this._objectOutputStream.flush();
                this._objectOutputStream.reset();
            }
        }

        public void setLogPrefix(byte[] logPrefix) {
            this._logPrefix = logPrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeProcessCallable(ProcessCallable<?> processCallable) throws IOException {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                try {
                    this._objectOutputStream.writeObject(processCallable);
                }
                catch (NotSerializableException nse) {
                    this._objectOutputStream.reset();
                    throw nse;
                }
                finally {
                    this._objectOutputStream.flush();
                }
            }
        }

        private ProcessOutputStream(ObjectOutputStream objectOutputStream, boolean error) {
            this._objectOutputStream = objectOutputStream;
            this._error = error;
        }
    }

    private static class ProcessCallableDispatcher
    implements Runnable {
        private final ObjectInputStream _objectInputStream;

        public ProcessCallableDispatcher(ObjectInputStream objectInputStream) {
            this._objectInputStream = objectInputStream;
        }

        @Override
        public void run() {
            ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
                private final AtomicLong _counter = new AtomicLong();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "ProcessCallable-runner-" + this._counter.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                }
            });
            while (true) {
                try {
                    while (true) {
                        ProcessCallable processCallable = (ProcessCallable)this._objectInputStream.readObject();
                        executorService.submit(() -> processCallable.call());
                    }
                }
                catch (Exception e) {
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    UnsyncPrintWriter unsyncPrintWriter = new UnsyncPrintWriter(unsyncByteArrayOutputStream);
                    unsyncPrintWriter.println(e);
                    e.printStackTrace(unsyncPrintWriter);
                    unsyncPrintWriter.println();
                    unsyncPrintWriter.flush();
                    System.err.write(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
                    System.err.flush();
                    continue;
                }
                break;
            }
        }
    }

    private static class PingbackProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final String _message;

        public PingbackProcessCallable(String message) {
            this._message = message;
        }

        @Override
        public String call() {
            return this._message;
        }
    }

    private static class LoggingProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final boolean _error;
        private final String _message;

        @Override
        public String call() {
            if (this._error) {
                System.err.print(this._message);
            } else {
                System.out.print(this._message);
            }
            return "";
        }

        private LoggingProcessCallable(String message, boolean error) {
            this._message = message;
            this._error = error;
        }
    }

    private static class HeartbeatThread
    extends Thread {
        private volatile boolean _detach;
        private final long _interval;
        private final ProcessCallable<String> _pringBackProcessCallable;
        private final ShutdownHook _shutdownHook;

        public HeartbeatThread(String message, long interval, ShutdownHook shutdownHook) {
            if (shutdownHook == null) {
                throw new IllegalArgumentException("Shutdown hook is null");
            }
            this._interval = interval;
            this._shutdownHook = shutdownHook;
            this._pringBackProcessCallable = new PingbackProcessCallable(message);
            this.setDaemon(true);
            this.setName(HeartbeatThread.class.getSimpleName());
        }

        public void detach() {
            this._detach = true;
            this.interrupt();
        }

        @Override
        public void run() {
            int shutdownCode = 0;
            Throwable shutdownThrowable = null;
            while (!this._detach) {
                try {
                    HeartbeatThread.sleep(this._interval);
                    ProcessContext.writeProcessCallable(this._pringBackProcessCallable);
                }
                catch (InterruptedException ie) {
                    if (this._detach) {
                        return;
                    }
                    shutdownThrowable = ie;
                    shutdownCode = 2;
                }
                catch (IOException ioe) {
                    shutdownThrowable = ioe;
                    shutdownCode = 1;
                }
                catch (Throwable throwable) {
                    shutdownThrowable = throwable;
                    shutdownCode = 3;
                }
                if (shutdownCode == 0) continue;
                this._detach = this._shutdownHook.shutdown(shutdownCode, shutdownThrowable);
            }
            AtomicReference heartBeatThreadReference = ProcessContext._heartbeatThreadAtomicReference;
            heartBeatThreadReference.compareAndSet(this, null);
        }
    }

    public static interface ShutdownHook {
        public static final int BROKEN_PIPE_CODE = 1;
        public static final int INTERRUPTION_CODE = 2;
        public static final int UNKNOWN_CODE = 3;

        public boolean shutdown(int var1, Throwable var2);
    }

    public static class ProcessContext {
        private static final ConcurrentMap<String, Object> _attributes = new ConcurrentHashMap<String, Object>();
        private static final AtomicReference<HeartbeatThread> _heartbeatThreadAtomicReference = new AtomicReference();
        private static ProcessOutputStream _processOutputStream;

        public static boolean attach(String message, long interval, ShutdownHook shutdownHook) {
            HeartbeatThread heartbeatThread = new HeartbeatThread(message, interval, shutdownHook);
            boolean value = _heartbeatThreadAtomicReference.compareAndSet(null, heartbeatThread);
            if (value) {
                heartbeatThread.start();
            }
            return value;
        }

        public static void detach() throws InterruptedException {
            HeartbeatThread heartbeatThread = _heartbeatThreadAtomicReference.getAndSet(null);
            if (heartbeatThread != null) {
                heartbeatThread.detach();
                heartbeatThread.join();
            }
        }

        public static ConcurrentMap<String, Object> getAttributes() {
            return _attributes;
        }

        public static boolean isAttached() {
            HeartbeatThread heartbeatThread = _heartbeatThreadAtomicReference.get();
            return heartbeatThread != null;
        }

        public static void writeProcessCallable(ProcessCallable<?> processCallable) throws IOException {
            _processOutputStream.writeProcessCallable(processCallable);
        }

        private static void _setProcessOutputStream(ProcessOutputStream processOutputStream) {
            _processOutputStream = processOutputStream;
        }

        private ProcessContext() {
        }
    }
}

