/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DocumentImpl
implements Document {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get("index.date.format.pattern");
    private static final int _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH = GetterUtil.getInteger(PropsUtil.get("index.sortable.text.fields.truncated.length"));
    private static final String _UID_PORTLET = "_PORTLET_";
    private static Format _dateFormat;
    private static final Set<String> _defaultSortableTextFields;
    private Map<String, Field> _fields = new HashMap<String, Field>();
    private Set<String> _sortableTextFields = _defaultSortableTextFields;

    @Deprecated
    public static String getLocalizedName(Locale locale, String name) {
        return Field.getLocalizedName(locale, name);
    }

    @Deprecated
    public static String getLocalizedName(String languageId, String name) {
        return Field.getLocalizedName(languageId, name);
    }

    @Deprecated
    public static String getSortableFieldName(String name) {
        return Field.getSortableFieldName(name);
    }

    @Deprecated
    public static String getSortFieldName(Sort sort, String scoreFieldName) {
        return Field.getSortFieldName(sort, scoreFieldName);
    }

    @Deprecated
    public static boolean isSortableFieldName(String name) {
        return Field.isSortableFieldName(name);
    }

    public static boolean isSortableTextField(String name) {
        return _defaultSortableTextFields.contains(name);
    }

    @Override
    public void add(Field field) {
        this._fields.put(field.getName(), field);
    }

    @Override
    public void addDate(String name, Date value) {
        if (value == null) {
            return;
        }
        this.addDate(name, new Date[]{value});
    }

    @Override
    public void addDate(String name, Date[] values) {
        if (values == null) {
            return;
        }
        String[] datesString = new String[values.length];
        Number[] datesTime = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Format dateFormat = this._getDateFormat();
            datesString[i] = dateFormat.format(values[i]);
            datesTime[i] = values[i].getTime();
        }
        this.createSortableNumericField(name, false, datesTime);
        Field field = this.createField(name, datesString);
        field.setDates(values);
    }

    @Override
    public void addDateSortable(String name, Date value) {
        if (value == null) {
            return;
        }
        this.addDateSortable(name, new Date[]{value});
    }

    @Override
    public void addDateSortable(String name, Date[] values) {
        if (values == null) {
            return;
        }
        String[] datesString = new String[values.length];
        Number[] datesTime = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Format dateFormat = this._getDateFormat();
            datesString[i] = dateFormat.format(values[i]);
            datesTime[i] = values[i].getTime();
        }
        this.createSortableNumericField(name, true, datesTime);
        this.addKeyword(name, datesString);
    }

    @Override
    public void addFile(String name, byte[] bytes, String fileExt) {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        this.addFile(name, is, fileExt);
    }

    @Override
    public void addFile(String name, File file, String fileExt) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.addFile(name, is, fileExt);
    }

    @Override
    public void addFile(String name, InputStream is, String fileExt) {
        this.addText(name, FileUtil.extractText(is, fileExt));
    }

    @Override
    public void addFile(String name, InputStream is, String fileExt, int maxStringLength) {
        this.addText(name, FileUtil.extractText(is, fileExt, maxStringLength));
    }

    @Override
    public void addGeoLocation(double latitude, double longitude) {
        this.addGeoLocation("geoLocation", latitude, longitude);
    }

    @Override
    public void addGeoLocation(String name, double latitude, double longitude) {
        Field field = new Field(name);
        field.setGeoLocationPoint(new GeoLocationPoint(latitude, longitude));
        this.add(field);
    }

    @Override
    public void addKeyword(String name, boolean value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Boolean value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, boolean[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Boolean[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, double value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Double value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, double[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Double[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, float value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Float value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, float[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Float[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, int value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, int[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Integer value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Integer[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, long value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Long value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, long[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Long[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, short value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Short value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, short[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Short[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, String value) {
        this.addKeyword(name, value, false);
    }

    @Override
    public void addKeyword(String name, String value, boolean lowerCase) {
        this.createKeywordField(name, value, lowerCase);
        this.createSortableKeywordField(name, value);
    }

    @Override
    public void addKeyword(String name, String[] values) {
        if (values == null) {
            return;
        }
        this.createField(name, values);
    }

    @Override
    public void addKeywordSortable(String name, Boolean value) {
        String valueString = String.valueOf(value);
        this.createKeywordField(name, valueString, false);
        this._createSortableTextField(name, true, valueString);
    }

    @Override
    public void addKeywordSortable(String name, Boolean[] values) {
        if (values == null) {
            return;
        }
        String[] valuesString = ArrayUtil.toStringArray((Object[])values);
        this.createField(name, valuesString);
        this._createSortableTextField(name, true, valuesString);
    }

    @Override
    public void addKeywordSortable(String name, String value) {
        this.createKeywordField(name, value, false);
        this._createSortableTextField(name, true, value);
    }

    @Override
    public void addKeywordSortable(String name, String[] values) {
        this.createField(name, values);
        this._createSortableTextField(name, true, values);
    }

    @Override
    public void addLocalizedKeyword(String name, Map<Locale, String> values) {
        this.addLocalizedKeyword(name, values, false);
    }

    @Override
    public void addLocalizedKeyword(String name, Map<Locale, String> values, boolean lowerCase) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (lowerCase) {
            HashMap<Locale, String> lowerCaseValues = new HashMap<Locale, String>(values.size());
            for (Map.Entry<Locale, String> entry : values.entrySet()) {
                String value = GetterUtil.getString(entry.getValue());
                lowerCaseValues.put(entry.getKey(), StringUtil.toLowerCase(value));
            }
            values = lowerCaseValues;
        }
        this.createField(name, values);
    }

    @Override
    public void addLocalizedKeyword(String name, Map<Locale, String> values, boolean lowerCase, boolean sortable) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (lowerCase) {
            HashMap<Locale, String> lowerCaseValues = new HashMap<Locale, String>(values.size());
            for (Map.Entry<Locale, String> entry : values.entrySet()) {
                String value = GetterUtil.getString(entry.getValue());
                lowerCaseValues.put(entry.getKey(), StringUtil.toLowerCase(value));
            }
            values = lowerCaseValues;
        }
        this.createField(name, values, sortable);
    }

    @Override
    public void addLocalizedText(String name, Map<Locale, String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Field field = this.createField(name, values);
        field.setTokenized(true);
    }

    @Override
    public void addNumber(String name, BigDecimal value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, BigDecimal[] values) {
        this.createNumberField(name, values);
    }

    @Override
    public void addNumber(String name, double value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, Double value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, double[] values) {
        if (values == null) {
            return;
        }
        this.createNumberField(name, ArrayUtil.toArray(values));
    }

    @Override
    public void addNumber(String name, Double[] values) {
        this.createNumberField(name, values);
    }

    @Override
    public void addNumber(String name, float value) {
        this.createNumberField(name, Float.valueOf(value));
    }

    @Override
    public void addNumber(String name, Float value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, float[] values) {
        if (values == null) {
            return;
        }
        this.createNumberField(name, ArrayUtil.toArray(values));
    }

    @Override
    public void addNumber(String name, Float[] values) {
        this.createNumberField(name, values);
    }

    @Override
    public void addNumber(String name, int value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, int[] values) {
        if (values == null) {
            return;
        }
        this.createNumberField(name, ArrayUtil.toArray(values));
    }

    @Override
    public void addNumber(String name, Integer value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, Integer[] values) {
        this.createNumberField(name, values);
    }

    @Override
    public void addNumber(String name, long value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, Long value) {
        this.createNumberField(name, value);
    }

    @Override
    public void addNumber(String name, long[] values) {
        if (values == null) {
            return;
        }
        this.createNumberField(name, ArrayUtil.toArray(values));
    }

    @Override
    public void addNumber(String name, Long[] values) {
        this.createNumberField(name, values);
    }

    @Override
    public void addNumber(String name, String value) {
        this.createNumberField(name, Long.valueOf(value));
    }

    @Override
    public void addNumber(String name, String[] values) {
        if (values == null) {
            return;
        }
        Number[] longs = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            longs[i] = Long.valueOf(values[i]);
        }
        this.createNumberField(name, longs);
    }

    @Override
    public void addNumberSortable(String name, BigDecimal value) {
        this.createNumberFieldWithTypedSortable(name, value);
    }

    @Override
    public void addNumberSortable(String name, BigDecimal[] values) {
        this.createNumberFieldWithTypedSortable(name, values);
    }

    @Override
    public void addNumberSortable(String name, Double value) {
        this.createNumberFieldWithTypedSortable(name, value);
    }

    @Override
    public void addNumberSortable(String name, Double[] values) {
        this.createNumberFieldWithTypedSortable(name, values);
    }

    @Override
    public void addNumberSortable(String name, Float value) {
        this.createNumberFieldWithTypedSortable(name, value);
    }

    @Override
    public void addNumberSortable(String name, Float[] values) {
        this.createNumberFieldWithTypedSortable(name, values);
    }

    @Override
    public void addNumberSortable(String name, Integer value) {
        this.createNumberFieldWithTypedSortable(name, value);
    }

    @Override
    public void addNumberSortable(String name, Integer[] values) {
        this.createNumberFieldWithTypedSortable(name, values);
    }

    @Override
    public void addNumberSortable(String name, Long value) {
        this.createNumberFieldWithTypedSortable(name, value);
    }

    @Override
    public void addNumberSortable(String name, Long[] values) {
        this.createNumberFieldWithTypedSortable(name, values);
    }

    @Override
    public void addText(String name, String value) {
        if (Validator.isNull(value)) {
            return;
        }
        Field field = this.createField(name, value);
        field.setTokenized(true);
        this.createSortableKeywordField(name, value);
    }

    @Override
    public void addText(String name, String[] values) {
        if (values == null) {
            return;
        }
        Field field = this.createField(name, values);
        field.setTokenized(true);
        this.createSortableKeywordField(name, values);
    }

    @Override
    public void addTextSortable(String name, String value) {
        if (Validator.isNull(value)) {
            return;
        }
        Field field = this.createField(name, value);
        field.setTokenized(true);
        this._createSortableTextField(name, true, value);
    }

    @Override
    public void addTextSortable(String name, String[] values) {
        if (values == null) {
            return;
        }
        Field field = this.createField(name, values);
        field.setTokenized(true);
        this._createSortableTextField(name, true, values);
    }

    @Override
    public void addUID(String portletId, long field1) {
        this.addUID(portletId, String.valueOf(field1));
    }

    @Override
    public void addUID(String portletId, long field1, String field2) {
        this.addUID(portletId, String.valueOf(field1), field2);
    }

    @Override
    public void addUID(String portletId, Long field1) {
        this.addUID(portletId, (long)field1);
    }

    @Override
    public void addUID(String portletId, Long field1, String field2) {
        this.addUID(portletId, (long)field1, field2);
    }

    @Override
    public void addUID(String portletId, String field1) {
        this.addUID(portletId, field1, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2) {
        this.addUID(portletId, field1, field2, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2, String field3) {
        this.addUID(portletId, field1, field2, field3, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2, String field3, String field4) {
        String uid = Field.getUID(portletId, field1, field2, field3, field4);
        this.addKeyword("uid", uid);
    }

    @Override
    public Object clone() {
        DocumentImpl documentImpl = new DocumentImpl();
        documentImpl.setSortableTextFields(this._sortableTextFields);
        return documentImpl;
    }

    @Override
    public String get(Locale locale, String name) {
        if (locale == null) {
            return this.get(name);
        }
        String localizedName = Field.getLocalizedName(locale, name);
        Field field = this.getField(localizedName);
        if (field == null) {
            field = this.getField(name);
        }
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    @Override
    public String get(Locale locale, String name, String defaultName) {
        if (locale == null) {
            return this.get(name, defaultName);
        }
        String localizedName = Field.getLocalizedName(locale, name);
        Field field = this.getField(localizedName);
        if (field == null) {
            localizedName = Field.getLocalizedName(locale, defaultName);
            field = this.getField(localizedName);
        }
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    @Override
    public String get(String name) {
        Field field = this.getField(name);
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    @Override
    public String get(String name, String defaultName) {
        Field field = this.getField(name);
        if (field == null) {
            return this.get(defaultName);
        }
        return field.getValue();
    }

    @Override
    public Date getDate(String name) throws ParseException {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat(_INDEX_DATE_FORMAT_PATTERN);
        return dateFormat.parse(this.get(name));
    }

    @Override
    public Field getField(String name) {
        return this.doGetField(name, false);
    }

    @Override
    public Map<String, Field> getFields() {
        return this._fields;
    }

    @Override
    public String getPortletId() {
        String uid = this.getUID();
        int pos = uid.indexOf(_UID_PORTLET);
        return uid.substring(0, pos);
    }

    @Override
    public String getUID() {
        Field field = this.getField("uid");
        if (field == null) {
            throw new RuntimeException("UID is not set");
        }
        return field.getValue();
    }

    @Override
    public String[] getValues(String name) {
        Field field = this.getField(name);
        if (field == null) {
            return new String[]{""};
        }
        return field.getValues();
    }

    @Override
    public boolean hasField(String name) {
        return this._fields.containsKey(name);
    }

    @Override
    public boolean isDocumentSortableTextField(String name) {
        return this._sortableTextFields.contains(name);
    }

    @Override
    public void remove(String name) {
        this._fields.remove(name);
    }

    public void setFields(Map<String, Field> fields) {
        this._fields = fields;
    }

    @Override
    public void setSortableTextFields(String[] sortableTextFields) {
        this._sortableTextFields = SetUtil.fromArray(sortableTextFields);
    }

    public String toString() {
        StringBundler sb = new StringBundler(5 * this._fields.size());
        this.toString(sb, this._fields.values());
        return sb.toString();
    }

    protected Field createField(String name) {
        return this.doGetField(name, true);
    }

    protected Field createField(String name, boolean sortable, String ... values) {
        Field field = this.createField(name);
        field.setSortable(sortable);
        field.setValues(values);
        return field;
    }

    protected Field createField(String name, Map<Locale, String> localizedValues) {
        return this.createField(name, localizedValues, false);
    }

    protected Field createField(String name, Map<Locale, String> localizedValues, boolean sortable) {
        Field field = this.createField(name);
        field.setLocalizedValues(localizedValues);
        field.setSortable(sortable);
        return field;
    }

    protected Field createField(String name, String ... values) {
        return this.createField(name, false, values);
    }

    protected void createKeywordField(String name, String value, boolean lowerCase) {
        if (lowerCase && Validator.isNotNull(value)) {
            value = StringUtil.toLowerCase(value);
        }
        this.createField(name, value);
    }

    protected void createNumberField(String name, boolean typify, Number value) {
        if (value == null) {
            return;
        }
        String valueString = String.valueOf(value);
        this.createSortableNumericField(name, typify, valueString, value.getClass());
        this.createField(name, valueString);
    }

    protected <T extends Number> void createNumberField(String name, boolean typify, T ... values) {
        if (values == null) {
            return;
        }
        this.createSortableNumericField(name, typify, (Number[])values);
        this.createField(name, ArrayUtil.toStringArray(values));
    }

    protected void createNumberField(String name, Number value) {
        this.createNumberField(name, false, value);
    }

    protected <T extends Number> void createNumberField(String name, T ... values) {
        this.createNumberField(name, false, (Number[])values);
    }

    protected void createNumberFieldWithTypedSortable(String name, Number value) {
        this.createNumberField(name, true, value);
    }

    protected <T extends Number> void createNumberFieldWithTypedSortable(String name, T ... values) {
        this.createNumberField(name, true, (Number[])values);
    }

    protected void createSortableKeywordField(String name, String value) {
        if (this.isDocumentSortableTextField(name)) {
            this._createSortableTextField(name, false, value);
        }
    }

    protected void createSortableKeywordField(String name, String[] values) {
        if (this.isDocumentSortableTextField(name)) {
            this._createSortableTextField(name, false, values);
        }
    }

    protected void createSortableNumericField(String name, boolean typify, String value, Class<? extends Number> clazz) {
        if (typify) {
            name = name.concat("_").concat("Number");
        }
        Field field = this.createField(Field.getSortableFieldName(name), value);
        field.setNumeric(true);
        field.setNumericClass(clazz);
    }

    protected <T extends Number> void createSortableNumericField(String name, boolean typify, T ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        Number minValue = (Number)Collections.min(Arrays.asList(values));
        this.createSortableNumericField(name, typify, String.valueOf(minValue), minValue.getClass());
    }

    protected void createSortableTextField(String name, String value) {
        this._createSortableTextField(name, false, value);
    }

    protected void createSortableTextField(String name, String[] values) {
        this._createSortableTextField(name, false, values);
    }

    protected Field doGetField(String name, boolean createIfNew) {
        Field field = this._fields.get(name);
        if (field == null && createIfNew) {
            field = new Field(name);
            this._fields.put(name, field);
        }
        return field;
    }

    protected void setSortableTextFields(Set<String> sortableTextFields) {
        this._sortableTextFields = sortableTextFields;
    }

    protected void toString(StringBundler sb, Collection<Field> fields) {
        sb.append("{");
        boolean firstField = true;
        for (Field field : fields) {
            if (!firstField) {
                sb.append(",");
                sb.append(" ");
            } else {
                firstField = false;
            }
            if (field.hasChildren()) {
                sb.append(field.getName());
                sb.append(":");
                this.toString(sb, field.getFields());
                continue;
            }
            sb.append(field.getName());
            sb.append("=");
            sb.append(Arrays.toString(field.getValues()));
        }
        sb.append("}");
    }

    private void _createSortableTextField(String name, boolean typify, String value) {
        if (typify) {
            name = name.concat("_").concat("String");
        }
        String truncatedValue = value;
        if (value.length() > _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH) {
            truncatedValue = value.substring(0, _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH);
        }
        this.createKeywordField(Field.getSortableFieldName(name), truncatedValue, true);
    }

    private void _createSortableTextField(String name, boolean typify, String[] values) {
        if (values.length == 0) {
            return;
        }
        this._createSortableTextField(name, typify, Collections.min(Arrays.asList(values)));
    }

    private Format _getDateFormat() {
        if (_dateFormat == null) {
            _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(_INDEX_DATE_FORMAT_PATTERN);
        }
        return _dateFormat;
    }

    static {
        _defaultSortableTextFields = SetUtil.fromArray(PropsUtil.getArray("index.sortable.text.fields"));
    }
}

