/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ScopeFacet
extends MultiValueFacet {
    private static final long[] _GROUP_IDS_FROM_SEARCH_CONTEXT_DEFAULT = new long[]{0L};
    private static final Log _log = LogFactoryUtil.getLog(ScopeFacet.class);

    public ScopeFacet(SearchContext searchContext) {
        super(searchContext);
        this.setFieldName("groupId");
    }

    protected long[] addScopeGroup(long groupId) {
        try {
            ArrayList<Long> groupIds = new ArrayList<Long>();
            groupIds.add(groupId);
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            List<Group> groups = GroupLocalServiceUtil.getGroups(group.getCompanyId(), Layout.class.getName(), group.getGroupId());
            for (Group scopeGroup : groups) {
                groupIds.add(scopeGroup.getGroupId());
            }
            return ArrayUtil.toLongArray(groupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            return new long[]{groupId};
        }
    }

    @Override
    protected BooleanClause<Filter> doGetFacetFilterBooleanClause() {
        SearchContext searchContext = this.getSearchContext();
        long[] groupIds = this.getGroupIds(searchContext);
        if (ArrayUtil.isEmpty(groupIds) || groupIds.length == 1 && groupIds[0] == 0L) {
            return null;
        }
        BooleanFilter facetBooleanFilter = new BooleanFilter();
        long ownerUserId = searchContext.getOwnerUserId();
        if (ownerUserId > 0L) {
            facetBooleanFilter.addRequiredTerm("userId", ownerUserId);
        }
        TermsFilter groupIdsTermsFilter = new TermsFilter("groupId");
        TermsFilter scopeGroupIdsTermsFilter = new TermsFilter("scopeGroupId");
        for (int i = 0; i < groupIds.length; ++i) {
            long groupId = groupIds[i];
            if (groupId <= 0L) continue;
            try {
                Group group = GroupLocalServiceUtil.getGroup(groupId);
                if (!GroupLocalServiceUtil.isLiveGroupActive(group)) continue;
                long parentGroupId = groupId;
                if (group.isLayout()) {
                    parentGroupId = group.getParentGroupId();
                }
                groupIdsTermsFilter.addValue(String.valueOf(parentGroupId));
                groupIds[i] = parentGroupId;
                if (!group.isLayout() && !searchContext.isScopeStrict()) continue;
                scopeGroupIdsTermsFilter.addValue(String.valueOf(groupId));
                continue;
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(e, e);
            }
        }
        searchContext.setGroupIds(groupIds);
        if (!groupIdsTermsFilter.isEmpty()) {
            facetBooleanFilter.add(groupIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        if (!scopeGroupIdsTermsFilter.isEmpty()) {
            facetBooleanFilter.add(scopeGroupIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        return BooleanClauseFactoryUtil.createFilter(searchContext, facetBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected long[] getGroupIds(SearchContext searchContext) {
        long[] groupIds = this.getGroupIdsFromFacetConfiguration();
        if (ArrayUtil.isEmpty(groupIds)) {
            groupIds = this.getGroupIdsFromSearchContext(searchContext);
        }
        if (ArrayUtil.isEmpty(groupIds)) {
            groupIds = searchContext.getGroupIds();
        }
        return groupIds;
    }

    protected long[] getGroupIdsFromFacetConfiguration() {
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        if (!dataJSONObject.has("values")) {
            return null;
        }
        JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
        long[] groupIds = new long[valuesJSONArray.length()];
        for (int i = 0; i < valuesJSONArray.length(); ++i) {
            groupIds[i] = valuesJSONArray.getLong(i);
        }
        return groupIds;
    }

    protected long[] getGroupIdsFromSearchContext(SearchContext searchContext) {
        String groupIdAttribute = GetterUtil.getString(searchContext.getAttribute("groupId"));
        if (Validator.isNull(groupIdAttribute)) {
            return null;
        }
        long groupId = GetterUtil.getLong(groupIdAttribute);
        if (groupId == 0L) {
            return _GROUP_IDS_FROM_SEARCH_CONTEXT_DEFAULT;
        }
        return this.addScopeGroup(groupId);
    }
}

