/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameDefinitionFactory;
import com.liferay.portal.kernel.security.auth.FullNameField;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.service.ListTypeServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class DefaultFullNameGenerator
implements FullNameGenerator {
    private static final Log _log = LogFactoryUtil.getLog(DefaultFullNameGenerator.class);

    @Override
    public String getFullName(String firstName, String middleName, String lastName) {
        String fullName = this.buildFullName(firstName, middleName, lastName, false);
        if (!this.isFullNameTooLong(fullName)) {
            return fullName;
        }
        fullName = this.buildFullName(firstName, middleName, lastName, true);
        if (!this.isFullNameTooLong(fullName)) {
            return fullName;
        }
        return this.shortenFullName(fullName);
    }

    @Override
    public String getLocalizedFullName(String firstName, String middleName, String lastName, Locale locale, long prefixId, long suffixId) {
        String fullName = this.buildLocalizedFullName(firstName, middleName, lastName, locale, prefixId, suffixId, false);
        if (!this.isFullNameTooLong(fullName)) {
            return fullName;
        }
        fullName = this.buildLocalizedFullName(firstName, middleName, lastName, locale, prefixId, suffixId, true);
        if (!this.isFullNameTooLong(fullName)) {
            return fullName;
        }
        return this.shortenFullName(fullName);
    }

    @Override
    public String[] splitFullName(String fullName) {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        if (Validator.isNull(fullName)) {
            return new String[]{firstName, middleName, lastName};
        }
        String[] name = StringUtil.split(fullName, ' ');
        firstName = name[0];
        middleName = "";
        lastName = name[name.length - 1];
        if (name.length > 2) {
            for (int i = 1; i < name.length - 1; ++i) {
                if (Validator.isNull(name[i].trim())) continue;
                if (i != 1) {
                    middleName = middleName + " ";
                }
                middleName = middleName + name[i].trim();
            }
        }
        return new String[]{firstName, middleName, lastName};
    }

    protected String buildFullName(String firstName, String middleName, String lastName, boolean useInitials) {
        StringBundler sb = new StringBundler(5);
        if (useInitials) {
            firstName = firstName.substring(0, 1);
        }
        sb.append(firstName);
        if (Validator.isNotNull(middleName)) {
            if (useInitials) {
                middleName = middleName.substring(0, 1);
            }
            sb.append(" ");
            sb.append(middleName);
        }
        if (Validator.isNotNull(lastName)) {
            sb.append(" ");
            sb.append(lastName);
        }
        return sb.toString();
    }

    protected String buildLocalizedFullName(String firstName, String middleName, String lastName, Locale locale, long prefixId, long suffixId, boolean useInitials) {
        ListType listType;
        HashMap<String, String> namesMap = new HashMap<String, String>();
        if (Validator.isNotNull(firstName)) {
            if (useInitials) {
                firstName = firstName.substring(0, 1);
            }
            namesMap.put("first-name", firstName);
        }
        if (Validator.isNotNull(middleName)) {
            if (useInitials) {
                middleName = middleName.substring(0, 1);
            }
            namesMap.put("middle-name", middleName);
        }
        if (Validator.isNotNull(lastName)) {
            namesMap.put("last-name", lastName);
        }
        if (prefixId != 0L) {
            try {
                listType = ListTypeServiceUtil.getListType(suffixId);
                String prefix = listType.getName();
                prefix = LanguageUtil.get(locale, prefix);
                namesMap.put("prefix", prefix);
            }
            catch (NoSuchListTypeException nslte) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Ignoring full name prefix " + prefixId, nslte);
                }
            }
            catch (PortalException pe) {
                throw new SystemException(pe);
            }
        }
        if (suffixId != 0L) {
            try {
                listType = ListTypeServiceUtil.getListType(suffixId);
                String suffix = listType.getName();
                suffix = LanguageUtil.get(locale, suffix);
                namesMap.put("suffix", suffix);
            }
            catch (NoSuchListTypeException nslte) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Ignoring full name suffix " + suffixId, nslte);
                }
            }
            catch (PortalException pe) {
                throw new SystemException(pe);
            }
        }
        FullNameDefinition fullNameDefinition = FullNameDefinitionFactory.getInstance(locale);
        List<FullNameField> fullNameFields = fullNameDefinition.getFullNameFields();
        StringBundler sb = new StringBundler(2 * fullNameFields.size());
        for (FullNameField fullNameField : fullNameFields) {
            String name = (String)namesMap.get(fullNameField.getName());
            if (name == null) continue;
            sb.append(" ");
            sb.append(name);
        }
        return StringUtil.trim(sb.toString());
    }

    protected boolean isFullNameTooLong(String fullName) {
        return fullName.length() > 75;
    }

    protected String shortenFullName(String fullName) {
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Full name exceeds ");
            sb.append(75);
            sb.append(" characters for user ");
            sb.append(fullName);
            sb.append(". Full name was shortened.");
            _log.info(sb.toString());
        }
        return fullName.substring(0, 75);
    }
}

