/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.util.CookieUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class Header
implements Externalizable {
    private Cookie _cookieValue;
    private long _dateValue;
    private int _intValue;
    private String _stringValue;
    private Type _type;

    public Header() {
    }

    public Header(Cookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie is null");
        }
        this._type = Type.COOKIE;
        this._cookieValue = cookie;
    }

    public Header(int integer) {
        this._type = Type.INTEGER;
        this._intValue = integer;
    }

    public Header(long date) {
        this._type = Type.DATE;
        this._dateValue = date;
    }

    public Header(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String is null");
        }
        this._type = Type.STRING;
        this._stringValue = string;
    }

    public void addToResponse(String key, HttpServletResponse httpServletResponse) {
        if (this._type == Type.COOKIE) {
            httpServletResponse.addCookie(this._cookieValue);
        } else if (this._type == Type.DATE) {
            httpServletResponse.addDateHeader(key, this._dateValue);
        } else if (this._type == Type.INTEGER) {
            httpServletResponse.addIntHeader(key, this._intValue);
        } else if (this._type == Type.STRING) {
            httpServletResponse.addHeader(key, this._stringValue);
        } else {
            throw new IllegalStateException("Invalid type " + (Object)((Object)this._type));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Header)) {
            return false;
        }
        Header header = (Header)obj;
        if (this._type != header._type) {
            return false;
        }
        if (this._type == Type.COOKIE) {
            return this._equals(this._cookieValue, header._cookieValue);
        }
        if (this._type == Type.DATE) {
            return this._dateValue == header._dateValue;
        }
        if (this._type == Type.INTEGER) {
            return this._intValue == header._intValue;
        }
        if (this._type == Type.STRING) {
            return this._stringValue.equals(header._stringValue);
        }
        throw new IllegalStateException("Invalid type " + (Object)((Object)this._type));
    }

    public int hashCode() {
        if (this._type == Type.COOKIE) {
            return this._hashCode(this._cookieValue);
        }
        if (this._type == Type.DATE) {
            return (int)(this._dateValue ^ this._dateValue >>> 32);
        }
        if (this._type == Type.INTEGER) {
            return this._intValue;
        }
        if (this._type == Type.STRING) {
            return this._stringValue.hashCode();
        }
        throw new IllegalStateException("Invalid type " + (Object)((Object)this._type));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        if (objectInput.readBoolean()) {
            int size = objectInput.readInt();
            byte[] data = new byte[size];
            objectInput.readFully(data);
            this._cookieValue = CookieUtil.deserialize(data);
        }
        this._dateValue = objectInput.readLong();
        this._intValue = objectInput.readInt();
        String stringValue = objectInput.readUTF();
        if (!stringValue.isEmpty()) {
            this._stringValue = stringValue;
        }
        this._type = Type.values()[objectInput.readInt()];
    }

    public void setToResponse(String key, HttpServletResponse httpServletResponse) {
        if (this._type == Type.COOKIE) {
            httpServletResponse.addCookie(this._cookieValue);
        } else if (this._type == Type.DATE) {
            httpServletResponse.setDateHeader(key, this._dateValue);
        } else if (this._type == Type.INTEGER) {
            httpServletResponse.setIntHeader(key, this._intValue);
        } else if (this._type == Type.STRING) {
            httpServletResponse.setHeader(key, this._stringValue);
        } else {
            throw new IllegalStateException("Invalid type " + (Object)((Object)this._type));
        }
    }

    public String toString() {
        if (this._type == Type.COOKIE) {
            return CookieUtil.toString(this._cookieValue);
        }
        if (this._type == Type.DATE) {
            return String.valueOf(this._dateValue);
        }
        if (this._type == Type.INTEGER) {
            return String.valueOf(this._intValue);
        }
        if (this._type == Type.STRING) {
            return this._stringValue;
        }
        throw new IllegalStateException("Invalid type " + (Object)((Object)this._type));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._cookieValue == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            byte[] data = CookieUtil.serialize(this._cookieValue);
            objectOutput.writeInt(data.length);
            objectOutput.write(data);
        }
        objectOutput.writeLong(this._dateValue);
        objectOutput.writeInt(this._intValue);
        if (this._stringValue == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this._stringValue);
        }
        objectOutput.writeInt(this._type.ordinal());
    }

    private boolean _equals(Cookie cookie1, Cookie cookie2) {
        if (cookie1 == cookie2) {
            return true;
        }
        return Objects.equals(cookie1.getComment(), cookie2.getComment()) && Objects.equals(cookie1.getDomain(), cookie2.getDomain()) && cookie1.getMaxAge() == cookie2.getMaxAge() && Objects.equals(cookie1.getName(), cookie2.getName()) && Objects.equals(cookie1.getPath(), cookie2.getPath()) && cookie1.getSecure() == cookie2.getSecure() && Objects.equals(cookie1.getValue(), cookie2.getValue()) && cookie1.getVersion() == cookie2.getVersion();
    }

    private int _hashCode(Cookie cookie) {
        int hashCode = HashUtil.hash((int)0, (Object)cookie.getComment());
        hashCode = HashUtil.hash((int)hashCode, (Object)cookie.getDomain());
        hashCode = HashUtil.hash((int)hashCode, (int)cookie.getMaxAge());
        hashCode = HashUtil.hash((int)hashCode, (Object)cookie.getName());
        hashCode = HashUtil.hash((int)hashCode, (Object)cookie.getPath());
        hashCode = HashUtil.hash((int)hashCode, (boolean)cookie.getSecure());
        hashCode = HashUtil.hash((int)hashCode, (Object)cookie.getValue());
        hashCode = HashUtil.hash((int)hashCode, (int)cookie.getVersion());
        return hashCode;
    }

    private static enum Type {
        COOKIE,
        DATE,
        INTEGER,
        STRING;

    }
}

