/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.util.comparator;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;

public class RepositoryModelReadCountComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "readCount ASC";
    public static final String ORDER_BY_DESC = "readCount DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"readCount"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, readCount ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, readCount DESC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public RepositoryModelReadCountComparator() {
        this(false);
    }

    public RepositoryModelReadCountComparator(boolean ascending) {
        this._ascending = ascending;
        this._orderByModel = false;
    }

    public RepositoryModelReadCountComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    @Override
    public int compare(T t1, T t2) {
        int value = 0;
        Long readCount1 = this.getReadCount(t1);
        Long readCount2 = this.getReadCount(t2);
        value = this._orderByModel ? ((t1 instanceof DLFolder || t1 instanceof Folder) && (t2 instanceof DLFolder || t2 instanceof Folder) ? readCount1.compareTo(readCount2) : (t1 instanceof DLFolder || t1 instanceof Folder ? -1 : (t2 instanceof DLFolder || t2 instanceof Folder ? 1 : readCount1.compareTo(readCount2)))) : readCount1.compareTo(readCount2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected long getFileShortcutReadCount(Object obj) {
        Serializable fileShortcut;
        long toFileEntryId = 0L;
        if (obj instanceof FileShortcut) {
            fileShortcut = (FileShortcut)obj;
            toFileEntryId = fileShortcut.getToFileEntryId();
        } else {
            fileShortcut = (DLFileShortcut)obj;
            toFileEntryId = fileShortcut.getToFileEntryId();
        }
        try {
            DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry(toFileEntryId);
            return dlFileEntry.getReadCount();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    protected long getReadCount(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getReadCount();
        }
        if (obj instanceof DLFileShortcut || obj instanceof FileShortcut) {
            return this.getFileShortcutReadCount(obj);
        }
        if (obj instanceof DLFolder || obj instanceof Folder) {
            return 0L;
        }
        FileEntry fileEntry = (FileEntry)obj;
        return fileEntry.getReadCount();
    }
}

