/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import java.io.Serializable;

public class DayAndPosition
implements Cloneable,
Serializable {
    public static final int NO_WEEKDAY = 0;
    private int _day;
    private int _position;

    public static boolean isValidDayOfWeek(int d) {
        return d == 0 || d == 1 || d == 2 || d == 3 || d == 4 || d == 5 || d == 6 || d == 7;
    }

    public static boolean isValidDayPosition(int p) {
        return p >= -53 && p <= 53;
    }

    public DayAndPosition() {
        this._day = 0;
        this._position = 0;
    }

    public DayAndPosition(int d, int p) {
        if (!DayAndPosition.isValidDayOfWeek(d)) {
            throw new IllegalArgumentException("Invalid day of week");
        }
        if (!DayAndPosition.isValidDayPosition(p)) {
            throw new IllegalArgumentException("Invalid day position");
        }
        this._day = d;
        this._position = p;
    }

    public Object clone() {
        try {
            DayAndPosition other = (DayAndPosition)super.clone();
            other._day = this._day;
            other._position = this._position;
            return other;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DayAndPosition)) {
            return false;
        }
        DayAndPosition that = (DayAndPosition)obj;
        return this.getDayOfWeek() == that.getDayOfWeek() && this.getDayPosition() == that.getDayPosition();
    }

    public int getDayOfWeek() {
        return this._day;
    }

    public int getDayPosition() {
        return this._position;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (int)this._day);
        return HashUtil.hash((int)hashCode, (int)this._position);
    }

    public void setDayOfWeek(int d) {
        if (!DayAndPosition.isValidDayOfWeek(d)) {
            throw new IllegalArgumentException("Invalid day of week");
        }
        this._day = d;
    }

    public void setDayPosition(int p) {
        if (!DayAndPosition.isValidDayPosition(p)) {
            throw new IllegalArgumentException();
        }
        this._position = p;
    }

    public String toString() {
        StringBundler sb = new StringBundler(6);
        Class<?> clazz = this.getClass();
        sb.append(clazz.getName());
        sb.append("[day=");
        sb.append(this._day);
        sb.append(",position=");
        sb.append(this._position);
        sb.append("]");
        return sb.toString();
    }
}

