/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.petra.string.StringBundler;
import java.io.Serializable;

public class Duration
implements Cloneable,
Serializable {
    private static final int _DAYS_PER_WEEK = 7;
    private static final int _HOURS_PER_DAY = 24;
    private static final long _MILLIS_PER_DAY = 86400000L;
    private static final long _MILLIS_PER_HOUR = 3600000L;
    private static final long _MILLIS_PER_MINUTE = 60000L;
    private static final long _MILLIS_PER_SECOND = 1000L;
    private static final long _MILLIS_PER_WEEK = 604800000L;
    private static final int _MINUTES_PER_HOUR = 60;
    private static final int _SECONDS_PER_MINUTE = 60;
    private int _days;
    private int _hours;
    private int _minutes;
    private int _seconds;
    private int _weeks;

    public Duration() {
    }

    public Duration(int w) {
        this._weeks = w;
    }

    public Duration(int h, int m, int s) {
        this(0, h, m, s);
    }

    public Duration(int d, int h, int m, int s) {
        this._days = d;
        this._hours = h;
        this._minutes = m;
        this._seconds = s;
    }

    public void clear() {
        this._weeks = 0;
        this._days = 0;
        this._hours = 0;
        this._minutes = 0;
        this._seconds = 0;
    }

    public Object clone() {
        try {
            Duration other = (Duration)super.clone();
            other._weeks = this._weeks;
            other._days = this._days;
            other._hours = this._hours;
            other._minutes = this._minutes;
            other._seconds = this._seconds;
            return other;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int getDays() {
        return this._days;
    }

    public int getHours() {
        return this._hours;
    }

    public long getInterval() {
        return (long)this._seconds * 1000L + (long)this._minutes * 60000L + (long)this._hours * 3600000L + (long)this._days * 86400000L + (long)this._weeks * 604800000L;
    }

    public int getMinutes() {
        return this._minutes;
    }

    public int getSeconds() {
        return this._seconds;
    }

    public int getWeeks() {
        return this._weeks;
    }

    public void setDays(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("Day value out of range");
        }
        this.checkNonWeeksOkay(d);
        this._days = d;
        this.normalize();
    }

    public void setHours(int h) {
        if (h < 0) {
            throw new IllegalArgumentException("Hour value out of range");
        }
        this.checkNonWeeksOkay(h);
        this._hours = h;
        this.normalize();
    }

    public void setInterval(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Negative-length interval");
        }
        this.clear();
        this._days = (int)(millis / 86400000L);
        this._seconds = (int)(millis % 86400000L / 1000L);
        this.normalize();
    }

    public void setMinutes(int m) {
        if (m < 0) {
            throw new IllegalArgumentException("Minute value out of range");
        }
        this.checkNonWeeksOkay(m);
        this._minutes = m;
        this.normalize();
    }

    public void setSeconds(int s) {
        if (s < 0) {
            throw new IllegalArgumentException("Second value out of range");
        }
        this.checkNonWeeksOkay(s);
        this._seconds = s;
        this.normalize();
    }

    public void setWeeks(int w) {
        if (w < 0) {
            throw new IllegalArgumentException("Week value out of range");
        }
        this.checkWeeksOkay(w);
        this._weeks = w;
    }

    public String toString() {
        StringBundler sb = new StringBundler(12);
        Class<?> clazz = this.getClass();
        sb.append(clazz.getName());
        sb.append("[weeks=");
        sb.append(this._weeks);
        sb.append(",days=");
        sb.append(this._days);
        sb.append(",hours=");
        sb.append(this._hours);
        sb.append(",minutes=");
        sb.append(this._minutes);
        sb.append(",seconds=");
        sb.append(this._seconds);
        sb.append("]");
        return sb.toString();
    }

    protected void checkNonWeeksOkay(int f) {
        if (f != 0 && this._weeks != 0) {
            throw new IllegalStateException("Weeks and non-weeks are incompatible");
        }
    }

    protected void checkWeeksOkay(int f) {
        if (f != 0 && (this._days != 0 || this._hours != 0 || this._minutes != 0 || this._seconds != 0)) {
            throw new IllegalStateException("Weeks and non-weeks are incompatible");
        }
    }

    protected void normalize() {
        this._minutes += this._seconds / 60;
        this._seconds %= 60;
        this._hours += this._minutes / 60;
        this._minutes %= 60;
        this._days += this._hours / 24;
        this._hours %= 24;
    }
}

