/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class AutoBatchPreparedStatementUtil {
    private static final int _HIBERNATE_JDBC_BATCH_SIZE = GetterUtil.getInteger(PropsUtil.get("hibernate.jdbc.batch_size"));
    private static final Class<?>[] _INTERFACES = new Class[]{PreparedStatement.class};
    private static final Method _addBatchMethod;
    private static final Method _closeMethod;
    private static final Method _executeBatch;
    private static volatile PortalExecutorManager _portalExecutorManager;

    public static PreparedStatement autoBatch(PreparedStatement preparedStatement) throws SQLException {
        Connection connection = preparedStatement.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.supportsBatchUpdates()) {
            return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new BatchInvocationHandler(preparedStatement));
        }
        return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new NoBatchInvocationHandler(preparedStatement));
    }

    public static PreparedStatement concurrentAutoBatch(Connection connection, String sql) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.supportsBatchUpdates()) {
            return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new ConcurrentBatchInvocationHandler(connection, sql));
        }
        return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new ConcurrentNoBatchInvocationHandler(connection, sql));
    }

    static /* synthetic */ PortalExecutorManager access$900() {
        return _portalExecutorManager;
    }

    static {
        _portalExecutorManager = ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, AutoBatchPreparedStatementUtil.class, "_portalExecutorManager", true);
        try {
            _addBatchMethod = PreparedStatement.class.getMethod("addBatch", new Class[0]);
            _closeMethod = PreparedStatement.class.getMethod("close", new Class[0]);
            _executeBatch = PreparedStatement.class.getMethod("executeBatch", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
    }

    private static class NoBatchInvocationHandler
    implements InvocationHandler {
        private final PreparedStatement _preparedStatement;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(_addBatchMethod)) {
                this._preparedStatement.executeUpdate();
                return null;
            }
            if (method.equals(_executeBatch)) {
                return new int[0];
            }
            return method.invoke((Object)this._preparedStatement, args);
        }

        private NoBatchInvocationHandler(PreparedStatement preparedStatement) {
            this._preparedStatement = preparedStatement;
        }
    }

    private static class ConcurrentNoBatchInvocationHandler
    implements InvocationHandler {
        private final Connection _connection;
        private final Set<Future<Void>> _futures = Collections.newSetFromMap(new ConcurrentHashMap());
        private final NoticeableExecutorService _noticeableExecutorService = AutoBatchPreparedStatementUtil.access$900().getPortalExecutor(ConcurrentNoBatchInvocationHandler.class.getName());
        private PreparedStatement _preparedStatement;
        private final String _sql;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(_addBatchMethod)) {
                this._executeUpdate();
                return null;
            }
            if (method.equals(_executeBatch)) {
                return new int[0];
            }
            if (method.equals(_closeMethod)) {
                Throwable throwable = null;
                for (Future<Void> future : this._futures) {
                    try {
                        future.get();
                    }
                    catch (Throwable t) {
                        if (t instanceof ExecutionException) {
                            t = t.getCause();
                        }
                        if (throwable == null) {
                            throwable = t;
                            continue;
                        }
                        throwable.addSuppressed(t);
                    }
                }
                if (throwable != null) {
                    throw throwable;
                }
            }
            return method.invoke((Object)this._preparedStatement, args);
        }

        private ConcurrentNoBatchInvocationHandler(Connection connection, String sql) throws SQLException {
            this._connection = connection;
            this._sql = sql;
            this._preparedStatement = this._connection.prepareStatement(this._sql);
        }

        private void _executeUpdate() throws SQLException {
            PreparedStatement preparedStatement = this._preparedStatement;
            NoticeableFuture noticeableFuture = this._noticeableExecutorService.submit(() -> {
                try {
                    preparedStatement.executeUpdate();
                }
                finally {
                    preparedStatement.close();
                }
                return null;
            });
            this._futures.add((Future<Void>)noticeableFuture);
            noticeableFuture.addFutureListener((FutureListener)new FutureListener<Void>(){

                public void complete(Future<Void> future) {
                    try {
                        future.get();
                        _futures.remove(future);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this._preparedStatement = this._connection.prepareStatement(this._sql);
        }
    }

    private static class ConcurrentBatchInvocationHandler
    implements InvocationHandler {
        private final Connection _connection;
        private int _count;
        private final Set<Future<Void>> _futures = Collections.newSetFromMap(new ConcurrentHashMap());
        private final NoticeableExecutorService _noticeableExecutorService = AutoBatchPreparedStatementUtil.access$900().getPortalExecutor(ConcurrentBatchInvocationHandler.class.getName());
        private PreparedStatement _preparedStatement;
        private final String _sql;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(_addBatchMethod)) {
                this._preparedStatement.addBatch();
                if (++this._count >= _HIBERNATE_JDBC_BATCH_SIZE) {
                    this._executeBatch();
                }
                return null;
            }
            if (method.equals(_executeBatch)) {
                if (this._count > 0) {
                    this._executeBatch();
                }
                return new int[0];
            }
            if (method.equals(_closeMethod)) {
                Throwable throwable = null;
                for (Future<Void> future : this._futures) {
                    try {
                        future.get();
                    }
                    catch (Throwable t) {
                        if (t instanceof ExecutionException) {
                            t = t.getCause();
                        }
                        if (throwable == null) {
                            throwable = t;
                            continue;
                        }
                        throwable.addSuppressed(t);
                    }
                }
                if (throwable != null) {
                    throw throwable;
                }
            }
            return method.invoke((Object)this._preparedStatement, args);
        }

        private ConcurrentBatchInvocationHandler(Connection connection, String sql) throws SQLException {
            this._connection = connection;
            this._sql = sql;
            this._preparedStatement = this._connection.prepareStatement(this._sql);
        }

        private void _executeBatch() throws SQLException {
            this._count = 0;
            PreparedStatement preparedStatement = this._preparedStatement;
            NoticeableFuture noticeableFuture = this._noticeableExecutorService.submit(() -> {
                try {
                    preparedStatement.executeBatch();
                }
                finally {
                    preparedStatement.close();
                }
                return null;
            });
            this._futures.add((Future<Void>)noticeableFuture);
            noticeableFuture.addFutureListener((FutureListener)new FutureListener<Void>(){

                public void complete(Future<Void> future) {
                    try {
                        future.get();
                        _futures.remove(future);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this._preparedStatement = this._connection.prepareStatement(this._sql);
        }
    }

    private static class BatchInvocationHandler
    implements InvocationHandler {
        private int _count;
        private final PreparedStatement _preparedStatement;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(_executeBatch)) {
                if (this._count > 0) {
                    this._count = 0;
                    return this._preparedStatement.executeBatch();
                }
                return new int[0];
            }
            if (!method.equals(_addBatchMethod)) {
                return method.invoke((Object)this._preparedStatement, args);
            }
            this._preparedStatement.addBatch();
            if (++this._count >= _HIBERNATE_JDBC_BATCH_SIZE) {
                this._preparedStatement.executeBatch();
                this._count = 0;
            }
            return null;
        }

        private BatchInvocationHandler(PreparedStatement preparedStatement) {
            this._preparedStatement = preparedStatement;
        }
    }
}

