/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.display.context.util;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseRequestHelper {
    private Company _company;
    private Long _companyId;
    private String _currentURL;
    private final HttpServletRequest _httpServletRequest;
    private Layout _layout;
    private LiferayPortletRequest _liferayPortletRequest;
    private LiferayPortletResponse _liferayPortletResponse;
    private Locale _locale;
    private PermissionChecker _permissionChecker;
    private PortletDisplay _portletDisplay;
    private String _portletId;
    private String _portletName;
    private String _portletResource;
    private String _portletTitle;
    private String _resourcePortletId;
    private String _resourcePortletName;
    private Long _scopeGroupId;
    private Long _siteGroupId;
    private ThemeDisplay _themeDisplay;
    private User _user;

    public BaseRequestHelper(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    public Company getCompany() {
        if (this._company == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._company = themeDisplay.getCompany();
        }
        return this._company;
    }

    public long getCompanyId() {
        if (this._companyId == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._companyId = themeDisplay.getCompanyId();
        }
        return this._companyId;
    }

    public String getCurrentURL() {
        if (this._currentURL == null) {
            PortletURL portletURL = PortletURLUtil.getCurrent(this.getLiferayPortletRequest(), this.getLiferayPortletResponse());
            this._currentURL = portletURL.toString();
        }
        return this._currentURL;
    }

    public Layout getLayout() {
        if (this._layout == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._layout = themeDisplay.getLayout();
        }
        return this._layout;
    }

    public LiferayPortletRequest getLiferayPortletRequest() {
        if (this._liferayPortletRequest == null) {
            PortletRequest portletRequest = (PortletRequest)this._httpServletRequest.getAttribute("javax.portlet.request");
            this._liferayPortletRequest = PortalUtil.getLiferayPortletRequest(portletRequest);
        }
        return this._liferayPortletRequest;
    }

    public LiferayPortletResponse getLiferayPortletResponse() {
        if (this._liferayPortletResponse == null) {
            PortletResponse portletResponse = (PortletResponse)this._httpServletRequest.getAttribute("javax.portlet.response");
            this._liferayPortletResponse = PortalUtil.getLiferayPortletResponse(portletResponse);
        }
        return this._liferayPortletResponse;
    }

    public Locale getLocale() {
        if (this._locale == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._locale = themeDisplay.getLocale();
        }
        return this._locale;
    }

    public PermissionChecker getPermissionChecker() {
        if (this._permissionChecker == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._permissionChecker = themeDisplay.getPermissionChecker();
        }
        return this._permissionChecker;
    }

    public PortletDisplay getPortletDisplay() {
        if (this._portletDisplay == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._portletDisplay = themeDisplay.getPortletDisplay();
        }
        return this._portletDisplay;
    }

    public String getPortletId() {
        if (this._portletId == null) {
            PortletDisplay portletDisplay = this.getPortletDisplay();
            this._portletId = portletDisplay.getId();
        }
        return this._portletId;
    }

    public String getPortletName() {
        if (this._portletName == null) {
            PortletDisplay portletDisplay = this.getPortletDisplay();
            this._portletName = portletDisplay.getPortletName();
        }
        return this._portletName;
    }

    public String getPortletResource() {
        if (this._portletResource == null) {
            PortletDisplay portletDisplay = this.getPortletDisplay();
            this._portletResource = portletDisplay.getPortletResource();
        }
        return this._portletResource;
    }

    public String getPortletTitle() {
        if (this._portletTitle == null) {
            PortletDisplay portletDisplay = this.getPortletDisplay();
            this._portletTitle = portletDisplay.getTitle();
        }
        return this._portletTitle;
    }

    public HttpServletRequest getRequest() {
        return this._httpServletRequest;
    }

    public String getResourcePortletId() {
        if (this._resourcePortletId == null) {
            this._resourcePortletId = Validator.isNotNull(this.getPortletResource()) ? this.getPortletResource() : this.getPortletId();
        }
        return this._resourcePortletId;
    }

    public String getResourcePortletName() {
        if (this._resourcePortletName == null) {
            String portletResource = this.getPortletResource();
            this._resourcePortletName = Validator.isNotNull(portletResource) ? portletResource : this.getPortletName();
        }
        return this._resourcePortletName;
    }

    public long getScopeGroupId() {
        if (this._scopeGroupId == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._scopeGroupId = themeDisplay.getScopeGroupId();
        }
        return this._scopeGroupId;
    }

    public long getSiteGroupId() {
        if (this._siteGroupId == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._siteGroupId = themeDisplay.getSiteGroupId();
        }
        return this._siteGroupId;
    }

    public ThemeDisplay getThemeDisplay() {
        if (this._themeDisplay == null) {
            this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        }
        return this._themeDisplay;
    }

    public User getUser() {
        if (this._user == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._user = themeDisplay.getUser();
        }
        return this._user;
    }

    public long getUserId() {
        if (this._user == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._user = themeDisplay.getUser();
        }
        return this._user.getUserId();
    }
}

